/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.service;

import cn.handyplus.fatigue.entity.FatiguePlayer;
import cn.handyplus.fatigue.lib.db.Db;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Player;

public class FatiguePlayerService {
    private static final FatiguePlayerService INSTANCE = new FatiguePlayerService();

    private FatiguePlayerService() {
    }

    public static FatiguePlayerService getInstance() {
        return INSTANCE;
    }

    public boolean add(FatiguePlayer fatiguePlayer) {
        return Db.use(FatiguePlayer.class).execution().insert(fatiguePlayer) > 0;
    }

    public Optional<FatiguePlayer> findByPlayerUuid(UUID playerUuid) {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().eq(FatiguePlayer::getPlayerUuid, playerUuid);
        return use.execution().selectOne();
    }

    public List<FatiguePlayer> findByPlayerUuidList(List<UUID> playerUuidList) {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().in(FatiguePlayer::getPlayerUuid, playerUuidList);
        return use.execution().list();
    }

    public List<FatiguePlayer> findAll() {
        return Db.use(FatiguePlayer.class).execution().list();
    }

    public List<FatiguePlayer> findByMaxFatigue(Integer maxFatigue) {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().eq(FatiguePlayer::getMaxAmount, 0).lt(FatiguePlayer::getAmount, maxFatigue);
        List<FatiguePlayer> list = use.execution().list();
        Db<FatiguePlayer> use1 = Db.use(FatiguePlayer.class);
        use1.where().ne(FatiguePlayer::getMaxAmount, 0).lt(FatiguePlayer::getAmount, FatiguePlayer::getMaxAmount);
        list.addAll(use1.execution().list());
        return list;
    }

    public boolean giveAmount(UUID playerUuid, Integer amount) {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().eq(FatiguePlayer::getPlayerUuid, playerUuid);
        use.update().add(FatiguePlayer::getAmount, FatiguePlayer::getAmount, amount);
        return use.execution().update() > 0;
    }

    public boolean takeAmount(UUID playerUuid, Integer amount) {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().eq(FatiguePlayer::getPlayerUuid, playerUuid);
        use.update().subtract(FatiguePlayer::getAmount, FatiguePlayer::getAmount, amount);
        return use.execution().update() > 0;
    }

    public boolean setAmount(UUID playerUuid, Integer amount) {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().eq(FatiguePlayer::getPlayerUuid, playerUuid);
        use.update().set(FatiguePlayer::getAmount, amount);
        return use.execution().update() > 0;
    }

    public boolean setMaxAmount(UUID playerUuid, Integer maxAmount) {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().eq(FatiguePlayer::getPlayerUuid, playerUuid);
        use.update().set(FatiguePlayer::getMaxAmount, maxAmount);
        return use.execution().update() > 0;
    }

    public boolean giveMaxAmount(UUID playerUuid, Integer maxAmount) {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().eq(FatiguePlayer::getPlayerUuid, playerUuid);
        use.update().add(FatiguePlayer::getMaxAmount, FatiguePlayer::getMaxAmount, maxAmount);
        return use.execution().update() > 0;
    }

    public boolean takeMaxAmount(UUID playerUuid, Integer maxAmount) {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().eq(FatiguePlayer::getPlayerUuid, playerUuid);
        use.update().subtract(FatiguePlayer::getMaxAmount, FatiguePlayer::getMaxAmount, maxAmount);
        return use.execution().update() > 0;
    }

    public void setPlayerName(Player player) {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().eq(FatiguePlayer::getPlayerUuid, player.getUniqueId());
        use.update().set(FatiguePlayer::getPlayerName, player.getName());
        use.execution().update();
    }

    public void setMaxAmountZero() {
        Db<FatiguePlayer> use = Db.use(FatiguePlayer.class);
        use.where().isNull(FatiguePlayer::getMaxAmount);
        use.update().set(FatiguePlayer::getMaxAmount, 0);
        use.execution().update();
    }
}

