/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.util;

import cn.handyplus.fatigue.api.PlayerFatigueApi;
import cn.handyplus.fatigue.entity.FatiguePlayer;
import cn.handyplus.fatigue.lib.constants.BaseConstants;
import cn.handyplus.fatigue.lib.core.CollUtil;
import cn.handyplus.fatigue.lib.expand.adapter.HandyRunnable;
import cn.handyplus.fatigue.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.HandyPermissionUtil;
import cn.handyplus.fatigue.service.FatiguePlayerService;
import cn.handyplus.fatigue.util.CacheUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class FatigueTask {
    private static final String OFFLINE_RESTORE = "offlineRestore";
    private static final String TIMING_RECOVERY = "timingRecovery";
    private static final String TIMING = "timing";
    private static final String TIMING_OFFLINE_RECOVERY = "timingOfflineRecovery";

    public static void init() {
        FatigueTask.setRecoveryFatigueTask();
        FatigueTask.setTimingRecoveryTask();
        CacheUtil.init();
    }

    private static void setRecoveryFatigueTask() {
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                int maxFatigue = BaseConstants.CONFIG.getInt("maxFatigue");
                if (BaseConstants.CONFIG.getBoolean(FatigueTask.OFFLINE_RESTORE)) {
                    List<FatiguePlayer> fatiguePlayers = FatiguePlayerService.getInstance().findByMaxFatigue(maxFatigue);
                    if (CollUtil.isEmpty(fatiguePlayers)) {
                        return;
                    }
                    for (FatiguePlayer fatiguePlayer : fatiguePlayers) {
                        FatigueTask.giveFatigue(maxFatigue, fatiguePlayer);
                    }
                } else {
                    List<UUID> playerUuidList = Bukkit.getOnlinePlayers().stream().map(Entity::getUniqueId).collect(Collectors.toList());
                    if (CollUtil.isEmpty(playerUuidList)) {
                        return;
                    }
                    List<FatiguePlayer> fatiguePlayerList = FatiguePlayerService.getInstance().findByPlayerUuidList(playerUuidList);
                    for (FatiguePlayer fatiguePlayer : fatiguePlayerList) {
                        FatigueTask.giveFatigue(maxFatigue, fatiguePlayer);
                    }
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 1200L, 20L * (long)BaseConstants.CONFIG.getInt("restoreSpeed"));
    }

    private static void setTimingRecoveryTask() {
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                String timing;
                if (!BaseConstants.CONFIG.getBoolean(FatigueTask.TIMING_RECOVERY)) {
                    return;
                }
                String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm"));
                if (!time.equals(timing = BaseConstants.CONFIG.getString(FatigueTask.TIMING))) {
                    return;
                }
                int maxFatigue = BaseConstants.CONFIG.getInt("maxFatigue");
                if (BaseConstants.CONFIG.getBoolean(FatigueTask.TIMING_OFFLINE_RECOVERY)) {
                    List<FatiguePlayer> fatiguePlayers = FatiguePlayerService.getInstance().findByMaxFatigue(maxFatigue);
                    if (CollUtil.isEmpty(fatiguePlayers)) {
                        return;
                    }
                    for (FatiguePlayer fatiguePlayer : fatiguePlayers) {
                        FatigueTask.setFatigue(maxFatigue, fatiguePlayer);
                    }
                } else {
                    List<UUID> playerUuidList = Bukkit.getOnlinePlayers().stream().map(Entity::getUniqueId).collect(Collectors.toList());
                    if (CollUtil.isEmpty(playerUuidList)) {
                        return;
                    }
                    List<FatiguePlayer> fatiguePlayerList = FatiguePlayerService.getInstance().findByPlayerUuidList(playerUuidList);
                    for (FatiguePlayer fatiguePlayer : fatiguePlayerList) {
                        FatigueTask.setFatigue(maxFatigue, fatiguePlayer);
                    }
                }
            }
        };
        HandySchedulerUtil.runTaskTimerAsynchronously(handyRunnable, 0L, 1200L);
    }

    private static void setFatigue(int maxFatigue, FatiguePlayer fatiguePlayer) {
        if (fatiguePlayer == null) {
            return;
        }
        if (fatiguePlayer.getMaxAmount() != 0) {
            maxFatigue = fatiguePlayer.getMaxAmount();
        }
        if (fatiguePlayer.getAmount() >= maxFatigue) {
            return;
        }
        PlayerFatigueApi.set(fatiguePlayer.getPlayerUuid(), maxFatigue);
        Player player = BaseUtil.getOnlinePlayer(fatiguePlayer.getPlayerUuid()).orElse(null);
        PlayerFatigueApi.sendActionBarMsg(player);
    }

    private static void giveFatigue(int maxFatigue, FatiguePlayer fatiguePlayer) {
        if (fatiguePlayer.getMaxAmount() != 0) {
            maxFatigue = fatiguePlayer.getMaxAmount();
        }
        if (fatiguePlayer.getAmount() >= maxFatigue) {
            return;
        }
        Player player = BaseUtil.getOnlinePlayer(fatiguePlayer.getPlayerUuid()).orElse(null);
        int amount = HandyPermissionUtil.getIntNumber(player, BaseConstants.CONFIG, "restore");
        if (fatiguePlayer.getAmount() + amount > maxFatigue) {
            amount = maxFatigue - fatiguePlayer.getAmount();
        }
        PlayerFatigueApi.give(fatiguePlayer.getPlayerUuid(), amount);
        PlayerFatigueApi.sendActionBarMsg(player);
    }
}

