/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.fatigue.util;

import cn.handyplus.fatigue.entity.FatiguePlayer;
import cn.handyplus.fatigue.lib.constants.BaseConstants;
import cn.handyplus.fatigue.lib.core.MapUtil;
import cn.handyplus.fatigue.lib.core.StrUtil;
import cn.handyplus.fatigue.lib.expand.adapter.HandyRunnable;
import cn.handyplus.fatigue.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.fatigue.lib.util.BaseUtil;
import cn.handyplus.fatigue.lib.util.MessageUtil;
import cn.handyplus.fatigue.service.FatiguePlayerService;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Player;

public class SendActionBarMsgUtil {
    private static final String IS_ACTION_BAR = "isActionBar";

    public static void sendActionBarMsg(final Player player) {
        if (!BaseConstants.CONFIG.getBoolean(IS_ACTION_BAR)) {
            return;
        }
        HandyRunnable handyRunnable = new HandyRunnable(){

            @Override
            public void run() {
                Map actionBarMsgMap = SendActionBarMsgUtil.getActionBarMsgMap(player);
                String actionBarMsg = BaseUtil.getMsgNotColor("actionBarMsg");
                if (StrUtil.isEmpty(actionBarMsg)) {
                    return;
                }
                for (String str : actionBarMsgMap.keySet()) {
                    actionBarMsg = StrUtil.replace(actionBarMsg, str, (String)actionBarMsgMap.get(str));
                }
                MessageUtil.sendActionbar(player, actionBarMsg);
            }
        };
        HandySchedulerUtil.runTaskAsynchronously(handyRunnable);
    }

    private static Map<String, String> getActionBarMsgMap(Player player) {
        HashMap<String, String> map = MapUtil.newHashMapWithExpectedSize(2);
        Optional<FatiguePlayer> fatiguePlayerOpt = FatiguePlayerService.getInstance().findByPlayerUuid(player.getUniqueId());
        Integer amount = 0;
        int maxAmount = BaseConstants.CONFIG.getInt("maxFatigue");
        if (fatiguePlayerOpt.isPresent()) {
            FatiguePlayer fatiguePlayer = fatiguePlayerOpt.get();
            amount = fatiguePlayer.getAmount();
            maxAmount = fatiguePlayer.getMaxAmount() != 0 ? fatiguePlayer.getMaxAmount() : maxAmount;
        }
        map.put("amount", amount.toString());
        map.put("maxAmount", Integer.toString(maxAmount));
        return map;
    }
}

