#version 330

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:matrix.glsl>
#moj_import <minecraft:dynamictransforms.glsl>
#moj_import <minecraft:globals.glsl>

//#define ON_END_GATEWAY
#define USE_OLD_COLORS

#ifdef USE_OLD_COLORS
    #define END_COLORS OLD_COLORS
#else
    #define END_COLORS COLORS
#endif

uniform sampler2D Sampler0;
uniform sampler2D Sampler1;

in vec4 texProj0;
in float sphericalVertexDistance;
in float cylindricalVertexDistance;
in vec3 pos;
in vec4 posNear;

const vec3[] COLORS = vec3[](
    vec3(0.022087, 0.098399, 0.110818),
    vec3(0.011892, 0.095924, 0.089485),
    vec3(0.027636, 0.101689, 0.100326),
    vec3(0.046564, 0.109883, 0.114838),
    vec3(0.064901, 0.117696, 0.097189),
    vec3(0.063761, 0.086895, 0.123646),
    vec3(0.084817, 0.111994, 0.166380),
    vec3(0.097489, 0.154120, 0.091064),
    vec3(0.106152, 0.131144, 0.195191),
    vec3(0.097721, 0.110188, 0.187229),
    vec3(0.133516, 0.138278, 0.148582),
    vec3(0.070006, 0.243332, 0.235792),
    vec3(0.196766, 0.142899, 0.214696),
    vec3(0.047281, 0.315338, 0.321970),
    vec3(0.204675, 0.390010, 0.302066),
    vec3(0.080955, 0.314821, 0.661491)
);

// colors from java random with seed 31100 from minecraft source, multiplied with the layer depth
const vec3[16] OLD_COLORS = vec3[](
    vec3(0.014725, 0.065600, 0.073878),
    vec3(0.006317, 0.050960, 0.047539),
    vec3(0.014739, 0.054234, 0.053507),
    vec3(0.024945, 0.058866, 0.061520),
    vec3(0.034947, 0.063375, 0.052333),
    vec3(0.034537, 0.047068, 0.066975),
    vec3(0.046264, 0.061088, 0.090753),
    vec3(0.053619, 0.084766, 0.050085),
    vec3(0.058973, 0.072858, 0.108439),
    vec3(0.054968, 0.061981, 0.105316),
    vec3(0.076295, 0.079016, 0.084904),
    vec3(0.040837, 0.141944, 0.137545),
    vec3(0.118059, 0.085740, 0.128817),
    vec3(0.029551, 0.197086, 0.201231),
    vec3(0.136450, 0.260007, 0.201378),
    vec3(0.060716, 0.236115, 0.496118));

const mat4 SCALE_TRANSLATE = mat4(
    0.5, 0.0, 0.0, 0.25,
    0.0, 0.5, 0.0, 0.25,
    0.0, 0.0, 1.0, 0.0,
    0.0, 0.0, 0.0, 1.0
);

mat4 end_portal_layer(float layer) {
    mat4 translate = mat4(
        1.0, 0.0, 0.0, 17.0 / layer,
        0.0, 1.0, 0.0, (2.0 + layer / 1.5) * (GameTime * 1.5),
        0.0, 0.0, 1.0, 0.0,
        0.0, 0.0, 0.0, 1.0
    );

    mat2 rotate = mat2_rotate_z(radians((layer * layer * 4321.0 + layer * 9.0) * 2.0));

    mat2 scale = mat2((4.5 - layer / 4.0) * 2.0);

    return mat4(scale * rotate) * translate * SCALE_TRANSLATE;
}

out vec4 fragColor;

vec3 endportal_vanilla() {
    vec3 color = textureProj(Sampler0, texProj0).rgb * COLORS[0];
    for (int i = 0; i < PORTAL_LAYERS; i++) {
        color += textureProj(Sampler1, texProj0 * end_portal_layer(float(i + 1))).rgb * COLORS[i];
    }
    return color;
}

vec3 endportal_1_10() {
    vec3 cam = posNear.xyz / posNear.w;
    vec3 dir = pos.xyz - cam;
    vec3 camPos = vec3(CameraBlockPos % 100000) - CameraOffset;

    #if defined ON_END_GATEWAY && PORTAL_LAYERS == 16
        vec3 normal = abs(normalize(cross(dFdx(dir), dFdy(dir))));
        if (all(greaterThan(normal.xx, normal.yz))) {
            dir = dir.zxy;
            camPos = camPos.zxy;
        } else if (all(greaterThan(normal.zz, normal.xy))) {
            dir = dir.xzy;
            camPos = camPos.xzy;
        }
    #endif
    vec3 worldPos = camPos + dir;
    
    // code based on minecraft source, with some alterations
    vec3 tex = vec3(0);
    for (int i = 0; i < 16; i++) {
        float yOffset = 16.0 - i;
        float scale = 0.0625;
        if (i == 0) {
            yOffset = 65.0F;
            scale = 0.125F;
        } else if (i == 1) {
            scale = 0.5F;
        }
        float rotation = (i * i * 4321.0 + i * 9.0) * 2.0;
        float Cos = cos(radians(rotation));
        float Sin = sin(radians(rotation));
        mat2 rot = mat2(Cos, Sin, -Sin, Cos);
        vec2 coord = worldPos.xz + dir.xz * yOffset / abs(dir.y);
        coord *= scale;
        coord = rot * coord + vec2(0, GameTime * 1.63);
        if (i == 0) {
            tex = texture(Sampler0, coord).rgb * END_COLORS[i];
        } else {
            #if defined USE_OLD_COLORS || PORTAL_LAYERS == 16
                tex += texture(Sampler1, coord).rgb * END_COLORS[i];
            #else
                tex += texture(Sampler1, coord).rgb * END_COLORS[i-1];
            #endif
        }
    }
    return tex;
}

void main() {
    vec3 color;
    if (ModelViewMat[3].z < -10000) {
        // in the menu always do the 2d version
        color = endportal_vanilla();
    } else if (PORTAL_LAYERS == 16) {
        #ifdef ON_END_GATEWAY
            color = endportal_1_10();
        #else
            color = endportal_vanilla();
        #endif
    } else {
        color = endportal_1_10();
    }
    fragColor = apply_fog(vec4(color, 1.0), sphericalVertexDistance, cylindricalVertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
}
