package thelm.packagedauto.client.screen;

import java.util.List;

import com.mojang.blaze3d.systems.RenderSystem;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.CycleRecipeTypePacket;
import thelm.packagedauto.network.packet.LoadRecipeListPacket;
import thelm.packagedauto.network.packet.SaveRecipeListPacket;
import thelm.packagedauto.network.packet.SetPatternIndexPacket;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class EncoderScreen extends BaseScreen<EncoderMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/encoder.png");

	public EncoderScreen(EncoderMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
		imageWidth = 258;
		imageHeight = 314;
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void init() {
		clearWidgets();
		super.init();
		int patternSlots = menu.blockEntity.patternItemHandlers.length;
		for(int i = 0; i < patternSlots; ++i) {
			addRenderableWidget(new ButtonPatternSlot(i, leftPos+30+(i%10)*18, topPos+(patternSlots > 10 ? 16 : 25)+(i/10)*18));
		}
		addRenderableWidget(new ButtonRecipeType(true, leftPos+189, topPos+74));
		addRenderableWidget(new ButtonRecipeType(false, leftPos+225, topPos+74));
		addRenderableWidget(new ButtonSavePatterns(leftPos+215, topPos+16));
		addRenderableWidget(new ButtonLoadPatterns(leftPos+215, topPos+34));
		addRenderableWidget(new ButtonClearPatterns(leftPos+171, topPos+56));
	}

	@Override
	protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
		IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
		for(int i = 0; i < 9; ++i) {
			for(int j = 0; j < 9; ++j) {
				Vec3i color = recipeType.getSlotColor(i*9+j);
				RenderSystem.setShaderColor(color.getX()/255F, color.getY()/255F, color.getZ()/255F, 1F);
				graphics.blit(BACKGROUND, leftPos+8+j*18, topPos+57+i*18, 258, 0, 16, 16, 512, 512);
			}
		}
		for(int i = 0; i < 3; ++i) {
			for(int j = 0; j < 3; ++j) {
				int slotIndex = 81+(i*3+j == 4 ? 0 : i*3+j < 4 ? i*3+j+1 : i*3+j);
				Vec3i color = recipeType.getSlotColor(slotIndex);
				RenderSystem.setShaderColor(color.getX()/255F, color.getY()/255F, color.getZ()/255F, 1F);
				graphics.blit(BACKGROUND, leftPos+198+j*18, topPos+111+i*18, 258, 0, 16, 16, 512, 512);
			}
		}
		RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
	}

	@Override
	protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
		String s = menu.blockEntity.getDisplayName().getString();
		graphics.drawString(font, s, imageWidth/2 - font.width(s)/2, 6, 0x404040, false);
		graphics.drawString(font, menu.inventory.getDisplayName().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040, false);
		String str = menu.patternItemHandler.recipeType.getShortDisplayName().getString();
		graphics.drawString(font, str, 212 - font.width(str)/2, 64, 0x404040, false);
		super.renderLabels(graphics, mouseX, mouseY);
		IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
		if(recipeType != null) {
			Object rep = recipeType.getRepresentation();
			if(rep instanceof TextureAtlasSprite sprite) {
				RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
				RenderSystem.setShaderTexture(0, InventoryMenu.BLOCK_ATLAS);
				graphics.blit(204, 75, 0, 16, 16, sprite);
			}
			if(rep instanceof ItemStack stack) {
				RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
				graphics.renderItem(stack, 204, 75);
			}
		}
	}

	@Override
	public int getItemAmountSpecificationLimit(Slot slot) {
		int stackLimit = slot.getItem().getMaxStackSize();
		return slot.index > 81 ? Math.max(stackLimit, 999) : stackLimit;
	}

	class ButtonPatternSlot extends AbstractButton {

		int id;

		ButtonPatternSlot(int id, int x, int y) {
			super(x, y, 18, 18, Component.empty());
			this.id = id;
			setTooltip(Tooltip.create(Component.translatable("block.packagedauto.encoder.pattern_slot", String.format("%02d", id))));
		}

		@Override
		public boolean isHoveredOrFocused() {
			return super.isHoveredOrFocused() || menu.blockEntity.patternIndex == id;
		}

		@Override
		protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.renderWidget(graphics, mouseX, mouseY, partialTicks);
			for(int i = 81; i < 90; ++i) {
				ItemStack stack = menu.blockEntity.patternItemHandlers[id].getStackInSlot(i);
				if(!stack.isEmpty()) {
					RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
					graphics.renderItem(stack, getX()+1, getY()+1);
					break;
				}
			}
		}

		@Override
		public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void onPress() {
			PacketHandler.INSTANCE.sendToServer(new SetPatternIndexPacket(id));
			menu.blockEntity.setPatternIndex(id);
			menu.setupSlots();
		}
	}

	class ButtonRecipeType extends AbstractButton {

		final boolean prev;

		ButtonRecipeType(boolean prev, int x, int y) {
			super(x, y, 10, 18, Component.empty());
			this.prev = prev;
			setTooltip(Tooltip.create(Component.translatable("block.packagedauto.encoder.recipe_type."+(prev ? "prev" : "next"))));
		}

		@Override
		protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.renderWidget(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			graphics.blit(BACKGROUND, getX()+1, getY()+1, prev ? 258 : 266, 48, 8, 16, 512, 512);
		}

		@Override
		public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void onPress() {
			PacketHandler.INSTANCE.sendToServer(new CycleRecipeTypePacket(prev));
			menu.patternItemHandler.cycleRecipeType(prev);
			menu.setupSlots();
		}
	}

	class ButtonSavePatterns extends AbstractButton {

		ButtonSavePatterns(int x, int y) {
			super(x, y, 36, 18, Component.empty());
			Component line0 = Component.translatable("block.packagedauto.encoder.save");
			Component line1 = Component.translatable("block.packagedauto.encoder.save.single").withStyle(ChatFormatting.GRAY);
			setTooltip(Tooltip.create(ComponentUtils.formatList(List.of(line0, line1), Component.literal("\n"))));
		}

		@Override
		protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.renderWidget(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			graphics.blit(BACKGROUND, getX()+1, getY()+1, 258, 16, 34, 16, 512, 512);
		}

		@Override
		public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void onPress() {
			boolean single = hasShiftDown();
			PacketHandler.INSTANCE.sendToServer(new SaveRecipeListPacket(single));
		}
	}

	class ButtonLoadPatterns extends AbstractButton {

		ButtonLoadPatterns(int x, int y) {
			super(x, y, 36, 18, Component.empty());
			Component line0 = Component.translatable("block.packagedauto.encoder.load");
			Component line1 = Component.translatable("block.packagedauto.encoder.load.single").withStyle(ChatFormatting.GRAY);
			setTooltip(Tooltip.create(ComponentUtils.formatList(List.of(line0, line1), Component.literal("\n"))));
		}

		@Override
		protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.renderWidget(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			graphics.blit(BACKGROUND, getX()+1, getY()+1, 258, 32, 34, 16, 512, 512);
		}

		@Override
		public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void onPress() {
			boolean single = hasShiftDown();
			PacketHandler.INSTANCE.sendToServer(new LoadRecipeListPacket(single, false));
			menu.blockEntity.loadRecipeList(single, false);
			menu.setupSlots();
		}
	}

	class ButtonClearPatterns extends AbstractButton {

		ButtonClearPatterns(int x, int y) {
			super(x, y, 7, 7, Component.empty());
			Component line0 = Component.translatable("block.packagedauto.encoder.clear");
			Component line1 = Component.translatable("block.packagedauto.encoder.clear.all").withStyle(ChatFormatting.GRAY);
			setTooltip(Tooltip.create(ComponentUtils.formatList(List.of(line0, line1), Component.literal("\n"))));
		}

		@Override
		protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {}

		@Override
		public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void onPress() {
			boolean single = !hasShiftDown();
			PacketHandler.INSTANCE.sendToServer(new LoadRecipeListPacket(single, true));
			menu.blockEntity.loadRecipeList(single, true);
			menu.setupSlots();
		}
	}
}
