package thelm.packagedauto.api;

import java.util.Collections;
import java.util.List;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

/**
 * Please override {@link IRecipeInfo#equals(IRecipeInfo)} when implementing a new recipe type.
 */
public interface IRecipeInfo {

	void readFromNBT(NBTTagCompound nbt);

	NBTTagCompound writeToNBT(NBTTagCompound nbt);

	IRecipeType getRecipeType();

	boolean isValid();

	List<IPackagePattern> getPatterns();

	default List<IPackagePattern> getExtraPatterns() {
		return Collections.emptyList();
	}

	List<ItemStack> getInputs();

	List<ItemStack> getOutputs();

	void generateFromStacks(List<ItemStack> input, List<ItemStack> output, World world);

	Int2ObjectMap<ItemStack> getEncoderStacks();

	default boolean validPatternIndex(int index) {
		return index >= 0 && index < getPatterns().size();
	}

	@Override
	boolean equals(Object obj);

	@Override
	int hashCode();
}
