/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei.category;

import java.awt.Color;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.block.BlockEncoder;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;
import thelm.packagedauto.integration.jei.category.PackageRecipeWrapper;

public class PackageRecipeCategory
implements IRecipeCategory<PackageRecipeWrapper> {
    public static final String UID = "packagedauto:package_recipe";
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;

    public PackageRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(PackagedAutoJEIPlugin.BACKGROUND, 0, 0, 162, 208);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((Block)BlockEncoder.INSTANCE));
        this.slotBackground = guiHelper.createDrawable(PackagedAutoJEIPlugin.BACKGROUND, 162, 118, 16, 16);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return I18n.func_74838_a((String)"jei.category.packagedauto.package_recipe");
    }

    public String getModName() {
        return "PackagedAuto";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, PackageRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        IRecipeType recipeType = recipeWrapper.recipe.getRecipeType();
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = i * 9 + j;
                stacks.init(index, true, j * 18, 10 + i * 18);
                stacks.setBackground(index, (IDrawable)new ColoredSlot(recipeType.getSlotColor(index)));
            }
        }
        for (int index = 0; index < 9; ++index) {
            int slot = 81 + index;
            stacks.init(slot, false, index * 18, 190);
        }
        stacks.set(ingredients);
    }

    class ColoredSlot
    implements IDrawable {
        private Color color;

        public ColoredSlot(Color color) {
            this.color = color;
        }

        public int getWidth() {
            return 18;
        }

        public int getHeight() {
            return 18;
        }

        public void draw(Minecraft minecraft, int xOffset, int yOffset) {
            GlStateManager.func_179131_c((float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f), (float)1.0f);
            PackageRecipeCategory.this.slotBackground.draw(minecraft, xOffset + 1, yOffset + 1);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

