/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IProxyMarkerItem;
import thelm.packagedauto.inventory.InventoryTileBase;
import thelm.packagedauto.tile.TileCraftingProxy;

public class InventoryCraftingProxy
extends InventoryTileBase {
    public final TileCraftingProxy tile;

    public InventoryCraftingProxy(TileCraftingProxy tile) {
        super(tile, 1);
        this.tile = tile;
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        this.loadMarker();
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = super.func_70298_a(index, count);
        this.loadMarker();
        return stack;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof IProxyMarkerItem && ((IProxyMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack) != null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.loadMarker();
    }

    @Override
    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public void loadMarker() {
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_77973_b() instanceof IProxyMarkerItem) {
            DirectionalGlobalPos pos = ((IProxyMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack);
            if (pos == null) {
                this.tile.target = null;
            } else if (this.tile.func_145831_w() != null && this.tile.func_145831_w().field_73011_w.getDimension() != pos.dimension()) {
                this.tile.target = null;
            } else {
                BlockPos dirVec = pos.blockPos().func_177973_b((Vec3i)this.tile.func_174877_v());
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.func_177958_n()), Math.abs(dirVec.func_177956_o()), Math.abs(dirVec.func_177952_p())});
                if (dist <= TileCraftingProxy.range) {
                    this.tile.target = pos;
                }
            }
        } else {
            this.tile.target = null;
        }
    }
}

