/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.client.gui.GuiCraftingProxy;
import thelm.packagedauto.container.ContainerCraftingProxy;
import thelm.packagedauto.integration.appeng.networking.HostHelperTileCraftingProxy;
import thelm.packagedauto.inventory.InventoryCraftingProxy;
import thelm.packagedauto.item.ItemProxyMarker;
import thelm.packagedauto.network.packet.PacketBeam;
import thelm.packagedauto.network.packet.PacketDirectionalMarker;
import thelm.packagedauto.network.packet.PacketSizedMarker;
import thelm.packagedauto.tile.TileBase;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2")})
public class TileCraftingProxy
extends TileBase
implements ITickable,
IPackageCraftingMachine,
ISettingsCloneable,
IGridHost,
IActionHost {
    public static int range = 8;
    public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60L, TimeUnit.SECONDS).build();
    public DirectionalGlobalPos target;
    public boolean firstTick = true;
    public HostHelperTileCraftingProxy hostHelper;

    public TileCraftingProxy() {
        this.setInventory(new InventoryCraftingProxy(this));
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileCraftingProxy(this);
        }
    }

    @Override
    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedauto.crafting_proxy.name");
    }

    @Override
    public String getConfigTypeName() {
        return "tile.packagedauto.crafting_proxy.name";
    }

    public void func_73660_a() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.field_145850_b.field_72995_K && this.hostHelper != null) {
                this.hostHelper.isActive();
            }
        }
    }

    @Override
    public boolean acceptPackage(IRecipeInfo recipeInfo, List<ItemStack> stacks, EnumFacing facing) {
        return this.acceptPackage(recipeInfo, stacks, facing, false);
    }

    @Override
    public boolean acceptPackage(IRecipeInfo recipeInfo, List<ItemStack> stacks, EnumFacing facing, boolean blocking) {
        IPackageCraftingMachine machine;
        if (!this.isBusy() && (machine = (IPackageCraftingMachine)this.field_145850_b.func_175625_s(this.target.blockPos())).acceptPackage(recipeInfo, stacks, this.target.direction(), blocking)) {
            EnumFacing dir = this.target.direction();
            Vec3d source = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
            Vec3d delta = new Vec3d((Vec3i)this.target.blockPos().func_177973_b((Vec3i)this.field_174879_c)).func_178787_e(new Vec3d(dir.func_176730_m()).func_186678_a(0.5));
            PacketBeam.sendBeams(source, Collections.singletonList(delta), 0xFF7F00, 6, true, this.field_145850_b.field_73011_w.getDimension(), 32.0);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        if (this.target == null) {
            return true;
        }
        BlockPos pos = this.target.blockPos();
        if (!this.field_145850_b.func_175667_e(pos)) {
            return true;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (tile != null && !(tile instanceof TileCraftingProxy) && tile instanceof IPackageCraftingMachine) {
            return ((IPackageCraftingMachine)tile).isBusy();
        }
        return true;
    }

    public void sendPreview(EntityPlayerMP player) {
        long currentTime = this.field_145850_b.func_82737_E();
        Long cachedTime = (Long)this.previewTimes.getIfPresent((Object)player.func_110124_au());
        if (cachedTime == null || currentTime - cachedTime > 180L) {
            this.previewTimes.put((Object)player.func_110124_au(), (Object)currentTime);
            if (this.target != null) {
                EnumFacing dir = this.target.direction();
                Vec3d source = new Vec3d((Vec3i)this.field_174879_c).func_72441_c(0.5, 0.5, 0.5);
                Vec3d delta = new Vec3d((Vec3i)this.target.blockPos().func_177973_b((Vec3i)this.field_174879_c)).func_178787_e(new Vec3d(dir.func_176730_m()).func_186678_a(0.5));
                PacketDirectionalMarker.sendDirectionalMarkers(player, Collections.singletonList(this.target), 0xFFFF00, 200);
                PacketBeam.sendBeams(player, source, Collections.singletonList(delta), 0xFFFF00, 200, false);
            }
            Vec3d lowerCorner = new Vec3d((Vec3i)this.field_174879_c).func_178786_a((double)range, (double)range, (double)range);
            Vec3d size = new Vec3d((double)(range * 2 + 1), (double)(range * 2 + 1), (double)(range * 2 + 1));
            PacketSizedMarker.sendSizedMarker(player, lowerCorner, size, 0xFF7F00, 200);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    @Override
    public ISettingsCloneable.Result loadConfig(NBTTagCompound nbt, EntityPlayer player) {
        ItemStack stack;
        InventoryPlayer playerInventory;
        block12: {
            if (!nbt.func_74764_b("Target")) {
                return ISettingsCloneable.Result.fail((ITextComponent)new TextComponentTranslation("item.packagedauto.settings_cloner.invalid", new Object[0]));
            }
            int availableCount = 0;
            playerInventory = player.field_71071_by;
            if (!this.inventory.func_70301_a(0).func_190926_b()) {
                if (this.inventory.func_70301_a(0).func_77973_b() == ItemProxyMarker.INSTANCE) {
                    availableCount += this.inventory.func_70301_a(0).func_190916_E();
                } else {
                    return ISettingsCloneable.Result.fail((ITextComponent)new TextComponentTranslation("tile.packagedauto.crafting_proxy.non_marker_present", new Object[0]));
                }
            }
            if (availableCount < 1) {
                for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
                    stack = playerInventory.func_70301_a(i);
                    if (!stack.func_190926_b() && stack.func_77973_b() == ItemProxyMarker.INSTANCE && !stack.func_77942_o()) {
                        availableCount += stack.func_190916_E();
                    }
                    if (availableCount < 1) {
                        continue;
                    }
                    break block12;
                }
                return ISettingsCloneable.Result.fail((ITextComponent)new TextComponentTranslation("tile.packagedauto.crafting_proxy.no_markers", new Object[0]));
            }
        }
        int removedCount = this.inventory.func_70301_a(0).func_190916_E();
        this.inventory.func_70299_a(0, ItemStack.field_190927_a);
        if (removedCount < 1) {
            for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
                ItemStack stack2 = playerInventory.func_70301_a(i);
                if (!stack2.func_190926_b() && stack2.func_77973_b() == ItemProxyMarker.INSTANCE && !stack2.func_77942_o()) {
                    removedCount += stack2.func_77979_a(1).func_190916_E();
                }
                if (removedCount >= 1) break;
            }
        }
        if (removedCount > 1 && !playerInventory.func_70441_a(stack = new ItemStack((Item)ItemProxyMarker.INSTANCE, removedCount - 1))) {
            EntityItem item = new EntityItem(this.field_145850_b, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
            item.func_145799_b(player.func_70005_c_());
            this.field_145850_b.func_72838_d((Entity)item);
        }
        NBTTagCompound targetTag = nbt.func_74775_l("Target");
        int dimension = targetTag.func_74762_e("Dimension");
        int[] posArray = targetTag.func_74759_k("Position");
        BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        EnumFacing direction = EnumFacing.func_82600_a((int)targetTag.func_74771_c("Direction"));
        DirectionalGlobalPos globalPos = new DirectionalGlobalPos(dimension, blockPos, direction);
        ItemStack stack3 = new ItemStack((Item)ItemProxyMarker.INSTANCE);
        ItemProxyMarker.INSTANCE.setDirectionalGlobalPos(stack3, globalPos);
        this.inventory.func_70299_a(0, stack3);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(NBTTagCompound nbt, EntityPlayer player) {
        if (this.target == null) {
            return ISettingsCloneable.Result.fail((ITextComponent)new TextComponentTranslation("tile.packagedauto.crafting_proxy.empty", new Object[0]));
        }
        NBTTagCompound targetTag = new NBTTagCompound();
        targetTag.func_74768_a("Dimension", this.target.dimension());
        targetTag.func_74783_a("Position", new int[]{this.target.x(), this.target.y(), this.target.z()});
        targetTag.func_74774_a("Direction", (byte)this.target.direction().func_176745_a());
        nbt.func_74782_a("Target", (NBTBase)targetTag);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiCraftingProxy(new ContainerCraftingProxy(player.field_71071_by, this));
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerCraftingProxy(player.field_71071_by, this);
    }
}

