/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client;

import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.client.RenderTimer;
import thelm.packagedauto.item.DistributorMarkerItem;
import thelm.packagedauto.item.ProxyMarkerItem;

public class WorldOverlayRenderer {
    public static final WorldOverlayRenderer INSTANCE = new WorldOverlayRenderer();
    public static final Vec3 BLOCK_SIZE = new Vec3(1.0, 1.0, 1.0);
    private Minecraft mc;
    private List<DirectionalMarkerInfo> directionalMarkers = new LinkedList<DirectionalMarkerInfo>();
    private List<SizedMarkerInfo> sizedMarkers = new LinkedList<SizedMarkerInfo>();
    private List<BeamInfo> beams = new LinkedList<BeamInfo>();

    private WorldOverlayRenderer() {
    }

    public void onConstruct() {
        this.mc = Minecraft.m_91087_();
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(this::onRenderLevelLast);
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || this.mc.f_91073_ == null || this.mc.f_91074_ == null || this.mc.m_91104_()) {
            return;
        }
        for (InteractionHand hand : InteractionHand.values()) {
            DirectionalGlobalPos globalPos;
            ItemStack stack = this.mc.f_91074_.m_21120_(hand);
            if (stack.m_150930_((Item)DistributorMarkerItem.INSTANCE) && (globalPos = DistributorMarkerItem.INSTANCE.getDirectionalGlobalPos(stack)) != null) {
                this.addDirectionalMarkers(List.of(globalPos), 65535, 1);
            }
            if (!stack.m_150930_((Item)ProxyMarkerItem.INSTANCE) || (globalPos = ProxyMarkerItem.INSTANCE.getDirectionalGlobalPos(stack)) == null) continue;
            this.addDirectionalMarkers(List.of(globalPos), 0xFF7F00, 1);
        }
    }

    public void onRenderLevelLast(RenderLevelLastEvent event) {
        this.render(event.getPoseStack(), event.getPartialTick());
    }

    public void addDirectionalMarkers(List<DirectionalGlobalPos> positions, int color, int lifetime) {
        this.directionalMarkers.add(new DirectionalMarkerInfo(positions, color, lifetime));
    }

    public void addSizedMarker(Vec3 lowerCorner, Vec3 size, int color, int lifetime) {
        this.sizedMarkers.add(new SizedMarkerInfo(lowerCorner, size, color, lifetime));
    }

    public void addBeams(Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout) {
        this.beams.add(new BeamInfo(source, deltas, color, lifetime, fadeout));
    }

    public void render(PoseStack poseStack, float partialTick) {
        int g;
        int r;
        int currentTick = RenderTimer.INSTANCE.getTicks();
        this.directionalMarkers.removeIf(marker -> marker.shouldRemove(currentTick));
        this.sizedMarkers.removeIf(marker -> marker.shouldRemove(currentTick));
        this.beams.removeIf(beam -> beam.shouldRemove(currentTick));
        float renderTick = (float)currentTick + partialTick;
        Vec3 cameraPos = this.mc.f_91063_.m_109153_().m_90583_();
        MultiBufferSource.BufferSource buffers = RenderTypeHelper.BUFFERS;
        VertexConsumer quadBuffer = buffers.m_6299_(RenderTypeHelper.MARKER_QUAD);
        VertexConsumer lineBuffer = buffers.m_6299_(RenderTypeHelper.MARKER_LINE_4);
        for (DirectionalMarkerInfo directionalMarkerInfo : this.directionalMarkers) {
            int r2 = directionalMarkerInfo.color >> 16 & 0xFF;
            int g2 = directionalMarkerInfo.color >> 8 & 0xFF;
            int b = directionalMarkerInfo.color & 0xFF;
            for (DirectionalGlobalPos globalPos : directionalMarkerInfo.positions) {
                if (!globalPos.dimension().equals((Object)this.mc.f_91073_.m_46472_())) continue;
                int range = 64;
                BlockPos blockPos = globalPos.blockPos();
                Vec3 distVec = cameraPos.m_82546_(Vec3.m_82512_((Vec3i)blockPos));
                if (Doubles.max((double[])new double[]{Math.abs(distVec.f_82479_), Math.abs(distVec.f_82480_), Math.abs(distVec.f_82481_)}) > (double)range) continue;
                poseStack.m_85836_();
                poseStack.m_85837_((double)blockPos.m_123341_() - cameraPos.f_82479_, (double)blockPos.m_123342_() - cameraPos.f_82480_, (double)blockPos.m_123343_() - cameraPos.f_82481_);
                Direction direction = globalPos.direction();
                this.addMarkerVertices(poseStack, quadBuffer, BLOCK_SIZE, direction, r2, g2, b, 127);
                this.addMarkerVertices(poseStack, lineBuffer, BLOCK_SIZE, null, r2, g2, b, 255);
                poseStack.m_85849_();
            }
        }
        RenderSystem.m_69465_();
        buffers.m_109911_();
        RenderSystem.m_69482_();
        lineBuffer = buffers.m_6299_(RenderTypeHelper.MARKER_LINE_4);
        for (SizedMarkerInfo sizedMarkerInfo : this.sizedMarkers) {
            Vec3 lowerCorner = sizedMarkerInfo.lowerCorner;
            poseStack.m_85836_();
            poseStack.m_85837_(lowerCorner.f_82479_ - cameraPos.f_82479_, lowerCorner.f_82480_ - cameraPos.f_82480_, lowerCorner.f_82481_ - cameraPos.f_82481_);
            r = sizedMarkerInfo.color >> 16 & 0xFF;
            g = sizedMarkerInfo.color >> 8 & 0xFF;
            int b = sizedMarkerInfo.color & 0xFF;
            this.addMarkerVertices(poseStack, lineBuffer, sizedMarkerInfo.size, null, r, g, b, 255);
            poseStack.m_85849_();
        }
        buffers.m_109911_();
        lineBuffer = buffers.m_6299_(RenderTypeHelper.BEAM_LINE_3);
        for (BeamInfo beamInfo : this.beams) {
            Vec3 source = beamInfo.source();
            poseStack.m_85836_();
            poseStack.m_85837_(source.f_82479_ - cameraPos.f_82479_, source.f_82480_ - cameraPos.f_82480_, source.f_82481_ - cameraPos.f_82481_);
            r = beamInfo.color >> 16 & 0xFF;
            g = beamInfo.color >> 8 & 0xFF;
            int b = beamInfo.color & 0xFF;
            int a = (int)(beamInfo.getAlpha(renderTick) * 255.0f);
            for (Vec3 delta : beamInfo.deltas) {
                this.addBeamVertices(poseStack, lineBuffer, delta, r, g, b, a);
            }
            poseStack.m_85849_();
        }
        buffers.m_109911_();
    }

    public void addMarkerVertices(PoseStack poseStack, VertexConsumer buffer, Vec3 delta, Direction direction, int r, int g, int b, int a) {
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        Matrix3f normal = poseStack.m_85850_().m_85864_();
        float x = (float)delta.f_82479_;
        float y = (float)delta.f_82480_;
        float z = (float)delta.f_82481_;
        if (direction == null || direction == Direction.NORTH) {
            buffer.m_85982_(pose, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, y, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, y, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (direction == null || direction == Direction.SOUTH) {
            buffer.m_85982_(pose, x, 0.0f, z).m_6122_(r, g, b, a).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, 0.0f, z).m_6122_(r, g, b, a).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, y, z).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, y, z).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (direction == null || direction == Direction.WEST) {
            buffer.m_85982_(pose, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, 0.0f, z).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, y, z).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, y, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (direction == null || direction == Direction.EAST) {
            buffer.m_85982_(pose, x, 0.0f, z).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            buffer.m_85982_(pose, x, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_5752_();
            buffer.m_85982_(pose, x, y, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
            buffer.m_85982_(pose, x, y, z).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_5752_();
        }
        if (direction == Direction.DOWN) {
            buffer.m_85982_(pose, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, 0.0f, z).m_6122_(r, g, b, a).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, 0.0f, z).m_6122_(r, g, b, a).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (direction == Direction.UP) {
            buffer.m_85982_(pose, 0.0f, y, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, y, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, y, z).m_6122_(r, g, b, a).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, y, z).m_6122_(r, g, b, a).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (direction == null) {
            buffer.m_85982_(pose, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, y, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, y, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, 0.0f, z).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, x, y, z).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, y, z).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            buffer.m_85982_(pose, 0.0f, 0.0f, z).m_6122_(r, g, b, a).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
        }
    }

    public void addBeamVertices(PoseStack poseStack, VertexConsumer buffer, Vec3 delta, int r, int g, int b, int a) {
        Vec3 normalVec = delta.m_82541_();
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        Matrix3f normal = poseStack.m_85850_().m_85864_();
        float x = (float)delta.f_82479_;
        float y = (float)delta.f_82480_;
        float z = (float)delta.f_82481_;
        float xn = (float)normalVec.f_82479_;
        float yn = (float)normalVec.f_82480_;
        float zn = (float)normalVec.f_82481_;
        buffer.m_85982_(pose, 0.0f, 0.0f, 0.0f).m_6122_(r, g, b, a).m_85977_(normal, xn, yn, zn).m_5752_();
        buffer.m_85982_(pose, x, y, z).m_6122_(r, g, b, a).m_85977_(normal, xn, yn, zn).m_5752_();
    }

    public record DirectionalMarkerInfo(List<DirectionalGlobalPos> positions, int color, int lifetime, int startTick) {
        public DirectionalMarkerInfo(List<DirectionalGlobalPos> positions, int color, int lifetime) {
            this(positions, color, lifetime, RenderTimer.INSTANCE.getTicks());
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }
    }

    public record SizedMarkerInfo(Vec3 lowerCorner, Vec3 size, int color, int lifetime, int startTick) {
        public SizedMarkerInfo(Vec3 lowerCorner, Vec3 size, int color, int lifetime) {
            this(lowerCorner, size, color, lifetime, RenderTimer.INSTANCE.getTicks());
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }
    }

    public record BeamInfo(Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout, int startTick) {
        public BeamInfo(Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout) {
            this(source, deltas, color, lifetime, fadeout, RenderTimer.INSTANCE.getTicks());
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }

        public float getAlpha(float renderTick) {
            if (!this.fadeout) {
                return 1.0f;
            }
            float diff = renderTick - (float)this.startTick;
            if (diff < 0.0f) {
                diff += 2097151.0f;
            }
            float factor = Math.min(diff / (float)this.lifetime, 1.0f);
            return 1.0f - factor * factor;
        }
    }

    public static class RenderTypeHelper
    extends RenderType {
        public static final RenderType MARKER_LINE_4 = RenderTypeHelper.m_173215_((String)"packagedauto:marker_line_4", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)8192, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(4.0))).m_110669_(f_110119_).m_110687_(f_110115_).m_110663_(f_110111_).m_110661_(f_110110_).m_110691_(false));
        public static final RenderType MARKER_QUAD = RenderTypeHelper.m_173215_((String)"packagedauto:marker_quad", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1024, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173104_).m_110669_(f_110119_).m_110685_(f_110139_).m_110687_(f_110115_).m_110663_(f_110111_).m_110661_(f_110110_).m_110691_(false));
        public static final RenderType BEAM_LINE_3 = RenderTypeHelper.m_173215_((String)"packagedauto:beam_line_3", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)8192, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(3.0))).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
        public static final MultiBufferSource.BufferSource BUFFERS = MultiBufferSource.m_109900_(Map.of(MARKER_LINE_4, new BufferBuilder(MARKER_LINE_4.m_110507_()), MARKER_QUAD, new BufferBuilder(MARKER_QUAD.m_110507_()), BEAM_LINE_3, new BufferBuilder(BEAM_LINE_3.m_110507_())), (BufferBuilder)Tesselator.m_85913_().m_85915_());

        private RenderTypeHelper(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }
    }
}

