/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.client.screen.AmountSpecifyingScreen;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.menu.VolumeAmountSpecifyingMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.SetItemStackPacket;
import thelm.packagedauto.util.MiscHelper;

public class VolumeAmountSpecifyingScreen
extends AmountSpecifyingScreen<VolumeAmountSpecifyingMenu> {
    private int containerSlot;
    private IVolumeStackWrapper stack;
    private int maxAmount;

    public VolumeAmountSpecifyingScreen(BaseScreen<?> parent, Inventory inventory, int containerSlot, IVolumeStackWrapper stack, int maxAmount) {
        super(parent, new VolumeAmountSpecifyingMenu(inventory, stack), inventory, (Component)Component.m_237115_((String)"gui.packagedauto.volume_amount_specifying"));
        this.containerSlot = containerSlot;
        this.stack = stack;
        this.maxAmount = maxAmount;
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack.getAmount();
    }

    @Override
    protected int getMaxAmount() {
        return this.maxAmount;
    }

    @Override
    protected int[] getIncrements() {
        return this.stack.getVolumeType().getIncrements();
    }

    @Override
    protected int[] getMultipliers() {
        return this.stack.getVolumeType().getMultipliers();
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        try {
            int amount = Mth.m_14045_((int)Integer.parseInt(this.amountField.m_94155_()), (int)0, (int)this.maxAmount);
            IVolumeStackWrapper newStack = this.stack.copy();
            newStack.setAmount(amount);
            PacketHandler.INSTANCE.sendToServer((Object)new SetItemStackPacket(this.containerSlot, MiscHelper.INSTANCE.makeVolumePackage(newStack)));
            this.close();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

