/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.emi;

import dev.emi.emi.api.stack.EmiIngredient;
import java.util.List;
import java.util.Optional;
import thelm.packagedauto.api.IRecipeSlotViewWrapper;
import thelm.packagedauto.integration.emi.PackagedAutoEMIPlugin;

public record EmiIngredientWrapper(EmiIngredient ingredient, Type type) implements IRecipeSlotViewWrapper
{
    public static IRecipeSlotViewWrapper input(EmiIngredient ingredient) {
        return new EmiIngredientWrapper(ingredient, Type.INPUT);
    }

    public static IRecipeSlotViewWrapper output(EmiIngredient ingredient) {
        return new EmiIngredientWrapper(ingredient, Type.OUTPUT);
    }

    public static IRecipeSlotViewWrapper catalyst(EmiIngredient ingredient) {
        return new EmiIngredientWrapper(ingredient, Type.CATALYST);
    }

    @Override
    public Optional<?> getDisplayedIngredient() {
        return PackagedAutoEMIPlugin.toStack(PackagedAutoEMIPlugin.getTreeEmiStack(this.ingredient));
    }

    @Override
    public List<?> getAllIngredients() {
        return this.ingredient.getEmiStacks().stream().flatMap(i -> PackagedAutoEMIPlugin.toStack(i).stream()).toList();
    }

    @Override
    public boolean isInput() {
        return this.type == Type.INPUT;
    }

    @Override
    public boolean isOutput() {
        return this.type == Type.OUTPUT;
    }

    public static enum Type {
        INPUT,
        OUTPUT,
        CATALYST;

    }
}

