/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.emi;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiResolutionRecipe;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.jemi.JemiStack;
import dev.emi.emi.runtime.EmiFavorite;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.client.screen.EncoderScreen;
import thelm.packagedauto.integration.emi.EncoderDragDropHandler;
import thelm.packagedauto.integration.emi.EncoderRecipeHandler;
import thelm.packagedauto.integration.emi.FluidVolumeStackProvider;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.util.ApiImpl;

@EmiEntrypoint
public class PackagedAutoEMIPlugin
implements EmiPlugin {
    private static final Logger LOGGER = LogManager.getLogger();
    private static List<ResourceLocation> allCategories;

    public void register(EmiRegistry registry) {
        registry.addDragDropHandler(EncoderScreen.class, (EmiDragDropHandler)new EncoderDragDropHandler());
        registry.addGenericStackProvider((EmiStackProvider)new FluidVolumeStackProvider());
        registry.addRecipeHandler(EncoderMenu.TYPE_INSTANCE, (EmiRecipeHandler)new EncoderRecipeHandler());
    }

    public static List<ResourceLocation> getAllRecipeCategories() {
        if (allCategories == null) {
            allCategories = EmiApi.getRecipeManager().getCategories().stream().map(c -> c.getId()).toList();
        }
        return allCategories;
    }

    public static EmiStack getTreeEmiStack(EmiIngredient ingredient) {
        if (ingredient instanceof EmiStack) {
            EmiStack emiStack = (EmiStack)ingredient;
            return emiStack;
        }
        try {
            if (ingredient instanceof EmiFavorite) {
                EmiFavorite emiFavorite = (EmiFavorite)ingredient;
                ingredient = emiFavorite.getStack();
            }
        }
        catch (Throwable e) {
            LOGGER.error("Unable to access favorited ingredient.", e);
        }
        try {
            EmiResolutionRecipe resolution;
            EmiRecipe emiRecipe;
            if (BoM.tree != null && (emiRecipe = BoM.tree.getRecipe(ingredient)) instanceof EmiResolutionRecipe) {
                resolution = (EmiResolutionRecipe)emiRecipe;
                return resolution.stack;
            }
            emiRecipe = BoM.getRecipe((EmiIngredient)ingredient);
            if (emiRecipe instanceof EmiResolutionRecipe) {
                resolution = (EmiResolutionRecipe)emiRecipe;
                return resolution.stack;
            }
        }
        catch (Throwable e) {
            LOGGER.error("Unable to access recipe tree.", e);
        }
        return (EmiStack)ingredient.getEmiStacks().get(0);
    }

    public static Optional<?> toStack(EmiStack emiStack) {
        if (emiStack == EmiStack.EMPTY) {
            return Optional.empty();
        }
        int amount = (int)emiStack.getAmount();
        if (amount == 0) {
            amount = 1000;
        }
        try {
            if (emiStack instanceof JemiStack) {
                JemiStack jemiStack = (JemiStack)emiStack;
                Object ingredient = jemiStack.ingredient;
                IVolumeType volumeType = ApiImpl.INSTANCE.getVolumeType(ingredient.getClass());
                if (volumeType != null) {
                    return volumeType.makeStackFromBase(ingredient, amount, null);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("Unable to access JEMI stack.", e);
        }
        IVolumeType volumeType = ApiImpl.INSTANCE.getVolumeType(emiStack.getKey().getClass());
        if (volumeType != null) {
            return volumeType.makeStackFromBase(emiStack.getKey(), amount, emiStack.getNbt());
        }
        return Optional.ofNullable(emiStack.getItemStack());
    }
}

