/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.UnpackagerBlock;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;

public class PackageProcessingCategory
implements IRecipeCategory<IPackageRecipeInfo> {
    public static final RecipeType<IPackageRecipeInfo> TYPE = RecipeType.create((String)"packagedauto", (String)"package_processing", IPackageRecipeInfo.class);
    public static final Component TITLE = Component.m_237115_((String)"jei.category.packagedauto.package_processing");
    private final IDrawable background;
    private final IDrawable icon;

    public PackageProcessingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(PackagedAutoJEIPlugin.BACKGROUND, 108, 0, 140, 64);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)UnpackagerBlock.INSTANCE));
    }

    public RecipeType<IPackageRecipeInfo> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IPackageRecipeInfo recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder slot;
        int index;
        int j;
        int i;
        List<IPackagePattern> patterns = recipe.getPatterns();
        List<ItemStack> outputs = recipe.getOutputs();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                index = i * 3 + j;
                slot = builder.addSlot(RecipeIngredientRole.INPUT, 1 + j * 18, 11 + i * 18);
                if (index >= patterns.size()) continue;
                slot.addItemStack(patterns.get(index).getOutput());
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                index = i * 3 + j;
                slot = builder.addSlot(RecipeIngredientRole.OUTPUT, 87 + j * 18, 11 + i * 18);
                if (index >= outputs.size()) continue;
                slot.addItemStack(outputs.get(index));
            }
        }
    }

    public void draw(IPackageRecipeInfo recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        String s = recipe.getRecipeType().getDisplayName().getString();
        font.m_92883_(stack, s, (float)(this.background.getWidth() / 2 - font.m_92895_(s) / 2), 0.0f, 0x404040);
    }
}

