/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.block.EncoderBlock;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;

public class PackageRecipeCategory
implements IRecipeCategory<IPackageRecipeInfo> {
    public static final RecipeType<IPackageRecipeInfo> TYPE = RecipeType.create((String)"packagedauto", (String)"package_recipe", IPackageRecipeInfo.class);
    public static final Component TITLE = Component.m_237115_((String)"jei.category.packagedauto.package_recipe");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;

    public PackageRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(PackagedAutoJEIPlugin.BACKGROUND, 0, 0, 162, 226);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)EncoderBlock.INSTANCE));
        this.slotBackground = guiHelper.createDrawable(PackagedAutoJEIPlugin.BACKGROUND, 162, 118, 16, 16);
    }

    public RecipeType<IPackageRecipeInfo> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IPackageRecipeInfo recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder slot;
        int i;
        IPackageRecipeType recipeType = recipe.getRecipeType();
        Int2ObjectMap<ItemStack> map = recipe.getEncoderStacks();
        List<ItemStack> outputs = recipe.getOutputs();
        List<IPackagePattern> patterns = recipe.getPatterns();
        for (i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = i * 9 + j;
                slot = builder.addSlot(RecipeIngredientRole.INPUT, 1 + j * 18, 11 + i * 18);
                slot.setBackground((IDrawable)new ColoredSlot(recipeType.getSlotColor(index)), 0, 0);
                if (!map.containsKey(index)) continue;
                slot.addItemStack((ItemStack)map.get(index));
            }
        }
        for (i = 0; i < 9; ++i) {
            slot = builder.addSlot(RecipeIngredientRole.OUTPUT, 1 + i * 18, 191);
            if (i >= outputs.size()) continue;
            slot.addItemStack(outputs.get(i));
        }
        for (i = 0; i < 9; ++i) {
            slot = builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 1 + i * 18, 209);
            if (i >= patterns.size()) continue;
            slot.addItemStack(patterns.get(i).getOutput());
        }
    }

    public void draw(IPackageRecipeInfo recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        String s = recipe.getRecipeType().getDisplayName().getString();
        font.m_92883_(stack, s, (float)(this.background.getWidth() / 2 - font.m_92895_(s) / 2), 0.0f, 0x404040);
    }

    class ColoredSlot
    implements IDrawable {
        private Vec3i color;

        public ColoredSlot(Vec3i color) {
            this.color = color;
        }

        public int getWidth() {
            return 16;
        }

        public int getHeight() {
            return 16;
        }

        public void draw(PoseStack poseStack, int xOffset, int yOffset) {
            RenderSystem.m_157429_((float)((float)this.color.m_123341_() / 255.0f), (float)((float)this.color.m_123342_() / 255.0f), (float)((float)this.color.m_123343_() / 255.0f), (float)1.0f);
            PackageRecipeCategory.this.slotBackground.draw(poseStack, xOffset, yOffset);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

