/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IDistributorMarkerItem;
import thelm.packagedauto.block.entity.DistributorBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;

public class DistributorItemHandler
extends BaseItemHandler<DistributorBlockEntity> {
    public DistributorItemHandler(DistributorBlockEntity blockEntity) {
        super(blockEntity, 81);
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.loadMarker(slot);
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        IDistributorMarkerItem marker;
        Item item = stack.m_41720_();
        return item instanceof IDistributorMarkerItem && (marker = (IDistributorMarkerItem)item).getDirectionalGlobalPos(stack) != null;
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return (IItemHandlerModifiable)EmptyHandler.INSTANCE;
    }

    @Override
    public void load(CompoundTag nbt) {
        super.load(nbt);
        for (int i = 0; i < 81; ++i) {
            this.loadMarker(i);
        }
    }

    public void loadMarker(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        Item item = stack.m_41720_();
        if (item instanceof IDistributorMarkerItem) {
            IDistributorMarkerItem marker = (IDistributorMarkerItem)item;
            DirectionalGlobalPos pos = marker.getDirectionalGlobalPos(stack);
            if (pos == null) {
                ((DistributorBlockEntity)this.blockEntity).positions.remove(slot);
            } else if (((DistributorBlockEntity)this.blockEntity).m_58904_() != null && !((DistributorBlockEntity)this.blockEntity).m_58904_().m_46472_().equals(pos.dimension())) {
                ((DistributorBlockEntity)this.blockEntity).positions.remove(slot);
            } else {
                BlockPos dirVec = pos.blockPos().m_121996_((Vec3i)((DistributorBlockEntity)this.blockEntity).m_58899_());
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.m_123341_()), Math.abs(dirVec.m_123342_()), Math.abs(dirVec.m_123343_())});
                if (dist <= DistributorBlockEntity.range) {
                    ((DistributorBlockEntity)this.blockEntity).positions.put(slot, (Object)pos);
                }
            }
        } else {
            ((DistributorBlockEntity)this.blockEntity).positions.remove(slot);
        }
    }
}

