/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IMarkerItem;

public abstract class MarkerItem
extends Item
implements IMarkerItem {
    public MarkerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (!level.f_46443_ && !player.m_6144_()) {
            if (this.getDirectionalGlobalPos(stack) != null) {
                return super.onItemUseFirst(stack, context);
            }
            ResourceKey dim = level.m_46472_();
            BlockPos pos = context.m_8083_();
            Direction dir = context.m_43719_();
            DirectionalGlobalPos globalPos = new DirectionalGlobalPos((ResourceKey<Level>)dim, pos, dir);
            if (stack.m_41613_() > 1) {
                ItemStack stack1 = stack.m_41620_(1);
                this.setDirectionalGlobalPos(stack1, globalPos);
                if (!player.m_150109_().m_36054_(stack1)) {
                    ItemEntity item = new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack1);
                    item.m_32052_(player.m_20148_());
                    level.m_7967_((Entity)item);
                }
            } else {
                this.setDirectionalGlobalPos(stack, globalPos);
            }
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_ && player.m_6144_() && this.isBound(player.m_21120_(hand))) {
            ItemStack stack = player.m_21120_(hand).m_41777_();
            this.setDirectionalGlobalPos(stack, null);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        DirectionalGlobalPos pos = this.getDirectionalGlobalPos(stack);
        if (pos != null) {
            MutableComponent dimComponent = Component.m_237113_((String)pos.dimension().m_135782_().toString());
            tooltip.add((Component)Component.m_237110_((String)"misc.packagedauto.dimension", (Object[])new Object[]{dimComponent}));
            MutableComponent posComponent = ComponentUtils.m_130748_((Component)Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{pos.x(), pos.y(), pos.z()}));
            tooltip.add((Component)Component.m_237110_((String)"misc.packagedauto.position", (Object[])new Object[]{posComponent}));
            MutableComponent dirComponent = Component.m_237115_((String)("misc.packagedauto." + pos.direction().m_122433_()));
            tooltip.add((Component)Component.m_237110_((String)"misc.packagedauto.direction", (Object[])new Object[]{dirComponent}));
        }
        super.m_7373_(stack, level, tooltip, isAdvanced);
    }

    @Override
    public DirectionalGlobalPos getDirectionalGlobalPos(ItemStack stack) {
        if (this.isBound(stack)) {
            CompoundTag nbt = stack.m_41783_();
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("Dimension")));
            int[] posArray = nbt.m_128465_("Position");
            BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
            Direction direction = Direction.m_122376_((int)nbt.m_128445_("Direction"));
            return new DirectionalGlobalPos((ResourceKey<Level>)dimension, blockPos, direction);
        }
        return null;
    }

    @Override
    public void setDirectionalGlobalPos(ItemStack stack, DirectionalGlobalPos pos) {
        if (pos != null) {
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128359_("Dimension", pos.dimension().m_135782_().toString());
            nbt.m_128385_("Position", new int[]{pos.x(), pos.y(), pos.z()});
            nbt.m_128344_("Direction", (byte)pos.direction().m_122411_());
        } else if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            nbt.m_128473_("Dimension");
            nbt.m_128473_("Position");
            nbt.m_128473_("Direction");
            if (nbt.m_128456_()) {
                stack.m_41751_(null);
            }
        }
    }

    public boolean isBound(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128441_("Dimension") && nbt.m_128441_("Position") && nbt.m_128441_("Direction");
    }
}

