/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.util;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CrudeIncrementalIntIdentityHashBiMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.packagedauto.api.IMiscHelper;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.api.PackagedAutoApi;
import thelm.packagedauto.util.MiscHelper;

public class ApiImpl
extends PackagedAutoApi {
    public static final ApiImpl INSTANCE = new ApiImpl();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final NavigableMap<ResourceLocation, IPackageRecipeType> RECIPE_REGISTRY = new TreeMap<ResourceLocation, IPackageRecipeType>();
    private static final Multimap<String, IPackageRecipeType> RECIPE_ORDER = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final CrudeIncrementalIntIdentityHashBiMap<IPackageRecipeType> RECIPE_IDS = CrudeIncrementalIntIdentityHashBiMap.m_184237_((int)4);
    private static final NavigableMap<ResourceLocation, IVolumeType> VOLUME_REGISTRY = new TreeMap<ResourceLocation, IVolumeType>();
    private static final Map<Class<?>, IVolumeType> VOLUME_CLASS_REGISTRY = new HashMap();

    private ApiImpl() {
    }

    @Override
    public synchronized boolean registerRecipeType(IPackageRecipeType type) {
        if (RECIPE_REGISTRY.containsKey(type.getName())) {
            return false;
        }
        RECIPE_IDS.m_13554_();
        RECIPE_REGISTRY.put(type.getName(), type);
        RECIPE_ORDER.put((Object)type.getName().m_135827_(), (Object)type);
        return true;
    }

    @Override
    public IPackageRecipeType getRecipeType(ResourceLocation name) {
        return (IPackageRecipeType)RECIPE_REGISTRY.get(name);
    }

    @Override
    public IPackageRecipeType getRecipeType(int id) {
        this.computeIds();
        return (IPackageRecipeType)RECIPE_IDS.m_7942_(id);
    }

    @Override
    public int getId(IPackageRecipeType type) {
        this.computeIds();
        return RECIPE_IDS.m_7447_((Object)type);
    }

    private synchronized void computeIds() {
        if (RECIPE_IDS.m_13562_() == 0) {
            RECIPE_ORDER.forEach((mod, type) -> RECIPE_IDS.m_13569_(type));
        }
    }

    @Override
    public NavigableMap<ResourceLocation, IPackageRecipeType> getRecipeTypeRegistry() {
        return Collections.unmodifiableNavigableMap(RECIPE_REGISTRY);
    }

    @Override
    public IPackageRecipeType getNextRecipeType(IPackageRecipeType type, boolean reverse) {
        int toGet = Math.floorMod(this.getId(type) + (!reverse ? 1 : -1), RECIPE_REGISTRY.size());
        IPackageRecipeType ret = this.getRecipeType(toGet);
        return ret;
    }

    @Override
    public synchronized boolean registerVolumeType(IVolumeType type) {
        if (VOLUME_REGISTRY.containsKey(type.getName()) || VOLUME_CLASS_REGISTRY.containsKey(type.getTypeClass())) {
            return false;
        }
        VOLUME_REGISTRY.put(type.getName(), type);
        VOLUME_CLASS_REGISTRY.put(type.getTypeClass(), type);
        return true;
    }

    @Override
    public IVolumeType getVolumeType(ResourceLocation name) {
        return (IVolumeType)VOLUME_REGISTRY.get(name);
    }

    @Override
    public IVolumeType getVolumeType(Class<?> typeClass) {
        return VOLUME_CLASS_REGISTRY.getOrDefault(typeClass, VOLUME_REGISTRY.values().stream().filter(t -> t.getTypeBaseClass().isAssignableFrom(typeClass)).findFirst().orElse(null));
    }

    @Override
    public NavigableMap<ResourceLocation, IVolumeType> getVolumeTypeRegistry() {
        return Collections.unmodifiableNavigableMap(VOLUME_REGISTRY);
    }

    @Override
    public IMiscHelper miscHelper() {
        return MiscHelper.INSTANCE;
    }
}

