package thelm.packagedauto.api;

import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public record SettingsClonerData(String type, CompoundTag data, GlobalPos globalPos) {

	public SettingsClonerData(String type, CompoundTag data, ResourceKey<Level> dimension, BlockPos blockPos) {
		this(type, data, GlobalPos.m_122643_(dimension, blockPos));
	}

	public String type() {
		return type;
	}

	public CompoundTag data() {
		return data;
	}

	public GlobalPos globalPos() {
		return globalPos;
	}

	public ResourceKey<Level> dimension() {
		return globalPos.m_122640_();
	}

	public BlockPos blockPos() {
		return globalPos.m_122646_();
	}

	public int x() {
		return blockPos().m_123341_();
	}

	public int y() {
		return blockPos().m_123342_();
	}

	public int z() {
		return blockPos().m_123343_();
	}
}
