package thelm.packagedauto.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import thelm.packagedauto.block.entity.BaseBlockEntity;

public abstract class BaseBlock extends Block implements EntityBlock {

	protected BaseBlock(Block.Properties properties) {
		super(properties);
	}

	@Override
	public boolean m_8133_(BlockState state, Level level, BlockPos pos, int id, int param) {
		super.m_8133_(state, level, pos, id, param);
		BlockEntity blockentity = level.m_7702_(pos);
		return blockentity == null ? false : blockentity.m_7531_(id, param);
	}

	@Override
	public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
		if(player.m_6144_()) {
			return InteractionResult.PASS;
		}
		if(!level.f_46443_) {
			BlockEntity blockEntity = level.m_7702_(pos);
			if(blockEntity instanceof MenuProvider menuProvider) {
				NetworkHooks.openScreen((ServerPlayer)player, menuProvider, pos);
			}
		}
		return InteractionResult.SUCCESS;
	}

	@Override
	public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
		if(!level.f_46443_) {
			BlockEntity blockEntity = level.m_7702_(pos);
			if(blockEntity instanceof BaseBlockEntity baseBlockEntity) {
				if(stack.m_41788_()) {
					baseBlockEntity.setCustomName(stack.m_41786_());
				}
				if(placer instanceof Player player) {
					baseBlockEntity.setOwner(player);
				}
			}
		}
	}

	@Override
	public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
		if(state.m_60734_() != newState.m_60734_()) {
			if(level.m_7702_(pos) instanceof BaseBlockEntity blockEntity) {
				IItemHandler handler = blockEntity.getItemHandler();
				for(int i = 0; i < handler.getSlots(); ++i) {
					ItemStack stack = handler.getStackInSlot(i);
					if(!stack.m_41619_()) {
						Containers.m_18992_(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stack);
					}
				}
			}
		}
		super.m_6810_(state, level, pos, newState, isMoving);
	}

	@Override
	public boolean m_7278_(BlockState state) {
		return true;
	}

	@Override
	public int m_6782_(BlockState pState, Level level, BlockPos pos) {
		BlockEntity blockEntity = level.m_7702_(pos);
		if(blockEntity instanceof BaseBlockEntity baseBlockEntity) {
			return baseBlockEntity.getComparatorSignal();
		}
		return 0;
	}
}
