package thelm.packagedauto.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.CraftingProxyBlockEntity;

public class CraftingProxyBlock extends BaseBlock {

	public static final CraftingProxyBlock INSTANCE = new CraftingProxyBlock();
	public static final Item ITEM_INSTANCE = new BlockItem(INSTANCE, new Item.Properties());

	protected CraftingProxyBlock() {
		super(BlockBehaviour.Properties.m_284310_().m_60913_(15F, 25F).m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56743_));
	}

	@Override
	public CraftingProxyBlockEntity m_142194_(BlockPos pos, BlockState state) {
		return CraftingProxyBlockEntity.TYPE_INSTANCE.m_155264_(pos, state);
	}

	@Override
	public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
		return BaseBlockEntity::tick;
	}

	@Override
	public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
		if(player.m_6144_()) {
			BlockEntity blockEntity = level.m_7702_(pos);
			if(blockEntity instanceof CraftingProxyBlockEntity proxy) {
				if(!level.f_46443_) {
					proxy.sendPreview((ServerPlayer)player);
				}
				return InteractionResult.SUCCESS;
			}
		}
		return super.m_6227_(state, level, pos, player, hand, hitResult);
	}
}
