package thelm.packagedauto.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.block.DistributorBlock;
import thelm.packagedauto.integration.appeng.blockentity.AEDistributorBlockEntity;
import thelm.packagedauto.inventory.DistributorItemHandler;
import thelm.packagedauto.item.DistributorMarkerItem;
import thelm.packagedauto.menu.DistributorMenu;
import thelm.packagedauto.network.packet.BeamPacket;
import thelm.packagedauto.network.packet.DirectionalMarkerPacket;
import thelm.packagedauto.network.packet.SizedMarkerPacket;
import thelm.packagedauto.recipe.IPositionedProcessingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;

public class DistributorBlockEntity extends BaseBlockEntity implements IPackageCraftingMachine, ISettingsCloneable {

	public static final BlockEntityType<DistributorBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.
			m_155273_(MiscHelper.INSTANCE.<BlockEntityType.BlockEntitySupplier<DistributorBlockEntity>>conditionalSupplier(
					()->ModList.get().isLoaded("ae2"),
					()->()->AEDistributorBlockEntity::new, ()->()->DistributorBlockEntity::new).get(),
					DistributorBlock.INSTANCE).m_58966_(null);

	public static int range = 16;
	public static int refreshInterval = 4;

	public final Int2ObjectMap<DirectionalGlobalPos> positions = new Int2ObjectArrayMap<>(81);
	public final Int2ObjectMap<ItemStack> pending = new Int2ObjectArrayMap<>(81);
	public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60, TimeUnit.SECONDS).build();

	public DistributorBlockEntity(BlockPos pos, BlockState state) {
		super(TYPE_INSTANCE, pos, state);
		setItemHandler(new DistributorItemHandler(this));
	}

	@Override
	protected Component getDefaultName() {
		return Component.m_237115_("block.packagedauto.distributor");
	}

	@Override
	public String getConfigTypeName() {
		return "block.packagedauto.distributor";
	}

	@Override
	public void tick() {
		if(!f_58857_.f_46443_) {
			if(f_58857_.m_46467_() % refreshInterval == 0 && !pending.isEmpty()) {
				distributeItems();
			}
		}
	}

	@Override
	public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
		if(!isBusy() && recipeInfo instanceof IPositionedProcessingPackageRecipeInfo recipe) {
			boolean blocking = false;
			if(f_58857_.m_7702_(f_58858_.m_121945_(direction)) instanceof UnpackagerBlockEntity unpackager) {
				blocking = unpackager.blocking;
			}
			Int2ObjectMap<ItemStack> matrix = recipe.getMatrix();
			if(!positions.keySet().containsAll(matrix.keySet())) {
				return false;
			}
			for(Int2ObjectMap.Entry<ItemStack> entry : matrix.int2ObjectEntrySet()) {
				BlockPos pos = positions.get(entry.getIntKey()).blockPos();
				if(!f_58857_.m_46749_(pos)) {
					return false;
				}
				BlockEntity blockEntity = f_58857_.m_7702_(pos);
				if(blockEntity == null) {
					return false;
				}
				ItemStack stack = entry.getValue().m_41777_();
				Direction dir = positions.get(entry.getIntKey()).direction();
				IItemHandler itemHandler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).orElse(null);
				if(stack.m_41720_() instanceof IVolumePackageItem vPackage &&
						vPackage.getVolumeType(stack) != null &&
						vPackage.getVolumeType(stack).hasBlockCapability(blockEntity, dir)) {
					if(blocking && !vPackage.getVolumeType(stack).isEmpty(blockEntity, dir)) {
						return false;
					}
					if(!MiscHelper.INSTANCE.fillVolume(blockEntity, dir, stack, true).m_41619_()) {
						return false;
					}
				}
				else if(itemHandler != null) {
					if(blocking && !MiscHelper.INSTANCE.isEmpty(itemHandler)) {
						return false;
					}
					if(!ItemHandlerHelper.insertItem(itemHandler, stack, true).m_41619_()) {
						return false;
					}
				}
				else {
					return false;
				}
			}
			for(Int2ObjectMap.Entry<ItemStack> entry : matrix.int2ObjectEntrySet()) {
				pending.put(entry.getIntKey(), entry.getValue().m_41777_());
			}
			distributeItems();
			return true;
		}
		return false;
	}

	@Override
	public boolean isBusy() {
		return !pending.isEmpty();
	}

	protected void distributeItems() {
		List<Vec3> deltas = new ArrayList<>();
		for(int i : pending.keySet().toIntArray()) {
			if(!positions.containsKey(i)) {
				ejectItems();
				break;
			}
			BlockPos pos = positions.get(i).blockPos();
			if(!f_58857_.m_46749_(pos)) {
				continue;
			}
			BlockEntity blockEntity = f_58857_.m_7702_(pos);
			if(blockEntity == null) {
				ejectItems();
				break;
			}
			ItemStack stack = pending.get(i);
			Direction dir = positions.get(i).direction();
			IItemHandler itemHandler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).orElse(null);
			ItemStack stackRem = stack;
			if(stack.m_41720_() instanceof IVolumePackageItem vPackage &&
					vPackage.getVolumeType(stack) != null &&
					vPackage.getVolumeType(stack).hasBlockCapability(blockEntity, dir)) {
				stackRem = MiscHelper.INSTANCE.fillVolume(blockEntity, dir, stack, false);
			}
			else if(itemHandler != null) {
				stackRem = ItemHandlerHelper.insertItem(itemHandler, stack, false);
			}
			else {
				ejectItems();
				break;
			}
			if(stackRem.m_41613_() < stack.m_41613_()) {
				Vec3 delta = Vec3.m_82528_(pos.m_121996_(f_58858_)).m_82549_(Vec3.m_82528_(dir.m_122436_()).m_82490_(0.5));
				deltas.add(delta);	
			}
			if(stackRem.m_41619_()) {
				pending.remove(i);
			}
			else {
				pending.put(i, stackRem);
			}
		}
		if(!deltas.isEmpty()) {
			Vec3 source = Vec3.m_82512_(f_58858_);
			BeamPacket.sendBeams(source, deltas, 0x00FFFF, 6, true, f_58857_.m_46472_(), 32);
			m_6596_();
		}
	}

	protected void ejectItems() {
		for(int i = 0; i < 81; ++i) {
			if(pending.containsKey(i)) {
				ItemStack stack = pending.remove(i);
				if(!stack.m_41619_()) {
					double dx = f_58857_.f_46441_.m_188501_()/2+0.25;
					double dy = f_58857_.f_46441_.m_188501_()/2+0.75;
					double dz = f_58857_.f_46441_.m_188501_()/2+0.25;
					ItemEntity itemEntity = new ItemEntity(f_58857_, f_58858_.m_123341_()+dx, f_58858_.m_123342_()+dy, f_58858_.m_123343_()+dz, stack);
					itemEntity.m_32060_();
					f_58857_.m_7967_(itemEntity);
				}
			}
		}
		m_6596_();
	}

	public void sendPreview(ServerPlayer player) {
		long currentTime = f_58857_.m_46467_();
		Long cachedTime = previewTimes.getIfPresent(player.m_20148_());
		if(cachedTime == null || currentTime-cachedTime > 180) {
			previewTimes.put(player.m_20148_(), currentTime);
			if(!positions.isEmpty()) {
				List<Vec3> deltas = positions.values().stream().map(globalPos->{
					BlockPos pos = globalPos.blockPos();
					Direction dir = globalPos.direction();
					return Vec3.m_82528_(pos.m_121996_(f_58858_)).m_82549_(Vec3.m_82528_(dir.m_122436_()).m_82490_(0.5));
				}).collect(Collectors.toList());
				Vec3 source = Vec3.m_82512_(f_58858_);
				DirectionalMarkerPacket.sendDirectionalMarkers(player, new ArrayList<>(positions.values()), 0x00FF7F, 200);
				BeamPacket.sendBeams(player, source, deltas, 0x00FF7F, 200, false);
			}
			Vec3 lowerCorner = Vec3.m_82528_(f_58858_).m_82492_(range, range, range);
			Vec3 size = new Vec3(range*2+1, range*2+1, range*2+1);
			SizedMarkerPacket.sendSizedMarker(player, lowerCorner, size, 0x00FFFF, 200);
		}
	}

	@Override
	public int getComparatorSignal() {
		if(!pending.isEmpty()) {
			return 15;
		}
		return 0;
	}

	@Override
	public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
		ListTag positionsTag = nbt.m_128437_("Positions", 10);
		if(positionsTag.isEmpty()) {
			return ISettingsCloneable.Result.fail(Component.m_237115_("item.packagedauto.settings_cloner.invalid"));
		}
		int requiredCount = positionsTag.size();
		int availableCount = 0;
		Inventory playerInventory = player.m_150109_();
		for(int i = 0; i < itemHandler.getSlots(); ++i) {
			ItemStack stack = itemHandler.getStackInSlot(i);
			if(!stack.m_41619_()) {
				if(stack.m_150930_(DistributorMarkerItem.INSTANCE)) {
					availableCount += stack.m_41613_();
				}
				else {
					return ISettingsCloneable.Result.fail(Component.m_237115_("block.packagedauto.distributor.non_marker_present"));
				}
			}
		}
		f:if(availableCount < requiredCount) {
			for(int i = 0; i < playerInventory.m_6643_(); ++i) {
				ItemStack stack = playerInventory.m_8020_(i);
				if(!stack.m_41619_() && stack.m_150930_(DistributorMarkerItem.INSTANCE) && !stack.m_41782_()) {
					availableCount += stack.m_41613_();
				}
				if(availableCount >= requiredCount) {
					break f;
				}
			}
			return ISettingsCloneable.Result.fail(Component.m_237115_("block.packagedauto.distributor.no_markers"));
		}
		int removedCount = 0;
		for(int i = 0; i < itemHandler.getSlots(); ++i) {
			removedCount += itemHandler.getStackInSlot(i).m_41613_();
			itemHandler.setStackInSlot(i, ItemStack.f_41583_);
		}
		if(removedCount < requiredCount) {
			for(int i = 0; i < playerInventory.m_6643_(); ++i) {
				ItemStack stack = playerInventory.m_8020_(i);
				if(!stack.m_41619_() && stack.m_150930_(DistributorMarkerItem.INSTANCE) && !stack.m_41782_()) {
					removedCount += stack.m_41620_(requiredCount - removedCount).m_41613_();
				}
				if(removedCount >= requiredCount) {
					break;
				}
			}
		}
		if(removedCount > requiredCount) {
			ItemStack stack = new ItemStack(DistributorMarkerItem.INSTANCE, removedCount-requiredCount);
			if(!playerInventory.m_36054_(stack)) {
				ItemEntity item = new ItemEntity(f_58857_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
				item.m_32052_(player.m_20148_());
				f_58857_.m_7967_(item);
			}
		}
		for(int i = 0; i < requiredCount; ++i) {
			CompoundTag positionTag = positionsTag.m_128728_(i);
			int index = positionTag.m_128445_("Index");
			ResourceKey<Level> dimension = ResourceKey.m_135785_(Registries.f_256858_, new ResourceLocation(positionTag.m_128461_("Dimension")));
			int[] posArray = positionTag.m_128465_("Position");
			BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
			Direction direction = Direction.m_122376_(positionTag.m_128445_("Direction"));
			DirectionalGlobalPos globalPos = new DirectionalGlobalPos(dimension, blockPos, direction);
			ItemStack stack = new ItemStack(DistributorMarkerItem.INSTANCE);
			DistributorMarkerItem.INSTANCE.setDirectionalGlobalPos(stack, globalPos);
			itemHandler.setStackInSlot(index, stack);
		}
		return ISettingsCloneable.Result.success();
	}

	@Override
	public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
		if(positions.isEmpty()) {
			return ISettingsCloneable.Result.fail(Component.m_237115_("block.packagedauto.distributor.empty"));
		}
		ListTag positionsTag = new ListTag();
		for(Int2ObjectMap.Entry<DirectionalGlobalPos> entry : positions.int2ObjectEntrySet()) {
			DirectionalGlobalPos pos = entry.getValue();
			CompoundTag positionTag = new CompoundTag();
			positionTag.m_128344_("Index", (byte)entry.getIntKey());
			positionTag.m_128359_("Dimension", pos.dimension().m_135782_().toString());
			positionTag.m_128385_("Position", new int[] {pos.x(), pos.y(), pos.z()});
			positionTag.m_128344_("Direction", (byte)pos.direction().m_122411_());
			positionsTag.add(positionTag);
		}
		nbt.m_128365_("Positions", positionsTag);
		return ISettingsCloneable.Result.success();
	}

	@Override
	public void m_142466_(CompoundTag nbt) {
		super.m_142466_(nbt);
		pending.clear();
		List<ItemStack> pendingList = new ArrayList<>();
		MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("Pending", 10), pendingList);
		for(int i = 0; i < 81 && i < pendingList.size(); ++i) {
			ItemStack stack = pendingList.get(i);
			if(!stack.m_41619_()) {
				pending.put(i, stack);
			}
		}
	}

	@Override
	public void m_183515_(CompoundTag nbt) {
		super.m_183515_(nbt);
		List<ItemStack> pendingList = new ArrayList<>();
		for(int i = 0; i < 81; ++i) {
			pendingList.add(pending.getOrDefault(i, ItemStack.f_41583_));
		}
		ListTag pendingTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), pendingList);
		nbt.m_128365_("Pending", pendingTag);
	}

	@Override
	public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
		sync(false);
		return new DistributorMenu(windowId, inventory, this);
	}
}
