package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.menu.BaseMenu;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.slot.FalseCopyVolumeSlot;
import thelm.packagedauto.slot.PreviewSlot;

public abstract class BaseScreen<C extends BaseMenu<?>> extends AbstractContainerScreen<C> {

	public final C menu;

	public BaseScreen(C menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
		this.menu = menu;
	}

	@Override
	public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
		m_280273_(graphics);
		super.m_88315_(graphics, mouseX, mouseY, partialTicks);
		m_280072_(graphics, mouseX, mouseY);
	}

	protected abstract ResourceLocation getBackgroundTexture();

	@Override
	protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
		RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
		if(f_97726_ > 256 || f_97727_ > 256) {
			graphics.m_280163_(getBackgroundTexture(), f_97735_, f_97736_, 0, 0, f_97726_, f_97727_, 512, 512);
		}
		else {
			graphics.m_280218_(getBackgroundTexture(), f_97735_, f_97736_, 0, 0, f_97726_, f_97727_);
		}
		renderBgAdditional(graphics, partialTicks, mouseX, mouseY);
		for(int i = 0; i < menu.f_38839_.size(); ++i) {
			Slot slot = menu.f_38839_.get(i);
			if(slot.m_6659_()) {
				if(slot instanceof FalseCopyVolumeSlot vSlot) {
					IVolumeStackWrapper stack = vSlot.volumeInventory.getStackInSlot(slot.getSlotIndex());
					if(!stack.isEmpty()) {
						stack.getVolumeType().render(graphics, f_97735_+slot.f_40220_, f_97736_+slot.f_40221_, stack);
						renderQuantity(graphics, f_97735_+slot.f_40220_, f_97736_+slot.f_40221_, String.valueOf(stack.getAmount()), 0xFFFFFF);
					}
				}
				else if((slot instanceof FalseCopySlot || slot instanceof PreviewSlot)
						&& slot.m_7993_().m_41720_() instanceof IVolumePackageItem vPackage) {
					IVolumeStackWrapper stack = vPackage.getVolumeStack(slot.m_7993_());
					if(!stack.isEmpty()) {
						stack.getVolumeType().render(graphics, f_97735_+slot.f_40220_, f_97736_+slot.f_40221_, stack);
					}
				}
			}
		}
	}

	protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {}

	@Override
	protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
		for(int i = 0; i < menu.f_38839_.size(); ++i) {
			Slot slot = menu.f_38839_.get(i);
			if(slot.m_6659_() && slot instanceof FalseCopyVolumeSlot vSlot) {
				IVolumeStackWrapper stack = vSlot.volumeInventory.getStackInSlot(slot.getSlotIndex());
				if(!stack.isEmpty() && inBounds(slot.f_40220_, slot.f_40221_, 17, 17, mouseX-f_97735_, mouseY-f_97736_)) {
					graphics.m_280666_(f_96547_, stack.getTooltip(), mouseX-f_97735_, mouseY-f_97736_);
				}
			}
		}
	}

	@Override
	protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
		if(mouseButton == 0 &&
				type != ClickType.QUICK_MOVE &&
				menu.m_142621_().m_41619_() &&
				slot instanceof FalseCopySlot &&
				slot.m_6659_() &&
				!slot.m_7993_().m_41619_()) {
			if(!m_96637_() && slot.m_7993_().m_41720_() instanceof IVolumePackageItem vPackage) {
				f_96541_.m_91152_(new VolumeAmountSpecifyingScreen(
						this, f_96541_.f_91074_.m_150109_(), slot.f_40219_, vPackage.getVolumeStack(slot.m_7993_()), getVolumeAmountSpecificationLimit(slot)));
			}
			else {
				f_96541_.m_91152_(new ItemAmountSpecifyingScreen(
						this, f_96541_.f_91074_.m_150109_(), slot.f_40219_, slot.m_7993_(), getItemAmountSpecificationLimit(slot)));
			}
		}
		else {
			super.m_6597_(slot, slotId, mouseButton, type);
		}
	}

	public int getItemAmountSpecificationLimit(Slot slot) {
		return Math.min(slot.m_6641_(), slot.m_7993_().m_41741_());
	}

	public int getVolumeAmountSpecificationLimit(Slot slot) {
		return 1000000;
	}

	public boolean inBounds(int x, int y, int w, int h, double ox, double oy) {
		return ox >= x && ox <= x + w && oy >= y && oy <= y + h;
	}

	public void renderQuantity(GuiGraphics graphics, int x, int y, String qty, int color) {
		boolean large = f_96541_.m_91390_();
		graphics.m_280168_().m_85836_();
		graphics.m_280168_().m_252880_(x, y, 300);
		if(!large) {
			graphics.m_280168_().m_85841_(0.5F, 0.5F, 1);
		}
		graphics.m_280056_(f_96547_, qty, (large ? 16 : 30) - f_96547_.m_92895_(qty), large ? 8 : 22, color, true);
		graphics.m_280168_().m_85849_();
	}
}
