package thelm.packagedauto.client.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.menu.CrafterMenu;

public class CrafterScreen extends BaseScreen<CrafterMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/crafter.png");

	public CrafterScreen(CrafterMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
		graphics.m_280218_(BACKGROUND, f_97735_+102, f_97736_+35, 176, 0, menu.blockEntity.getScaledProgress(22), 16);
		int scaledEnergy = menu.blockEntity.getScaledEnergy(40);
		graphics.m_280218_(BACKGROUND, f_97735_+10, f_97736_+10+40-scaledEnergy, 176, 16+40-scaledEnergy, 12, scaledEnergy);
	}

	@Override
	protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		graphics.m_280056_(f_96547_, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040, false);
		graphics.m_280056_(f_96547_, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040, false);
		if(mouseX-f_97735_ >= 10 && mouseY-f_97736_ >= 10 && mouseX-f_97735_ <= 21 && mouseY-f_97736_ <= 49) {
			graphics.m_280557_(f_96547_, Component.m_237113_(menu.blockEntity.getEnergyStorage().getEnergyStored()+" / "+menu.blockEntity.getEnergyStorage().getMaxEnergyStored()+" FE"), mouseX-f_97735_, mouseY-f_97736_);
		}
		super.m_280003_(graphics, mouseX, mouseY);
	}
}
