package thelm.packagedauto.client.screen;

import java.util.List;

import com.mojang.blaze3d.systems.RenderSystem;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.CycleRecipeTypePacket;
import thelm.packagedauto.network.packet.LoadRecipeListPacket;
import thelm.packagedauto.network.packet.SaveRecipeListPacket;
import thelm.packagedauto.network.packet.SetPatternIndexPacket;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class EncoderScreen extends BaseScreen<EncoderMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/encoder.png");

	public EncoderScreen(EncoderMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
		f_97726_ = 258;
		f_97727_ = 314;
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void m_7856_() {
		m_169413_();
		super.m_7856_();
		int patternSlots = menu.blockEntity.patternItemHandlers.length;
		for(int i = 0; i < patternSlots; ++i) {
			m_142416_(new ButtonPatternSlot(i, f_97735_+30+(i%10)*18, f_97736_+(patternSlots > 10 ? 16 : 25)+(i/10)*18));
		}
		m_142416_(new ButtonRecipeType(true, f_97735_+189, f_97736_+74));
		m_142416_(new ButtonRecipeType(false, f_97735_+225, f_97736_+74));
		m_142416_(new ButtonSavePatterns(f_97735_+215, f_97736_+16));
		m_142416_(new ButtonLoadPatterns(f_97735_+215, f_97736_+34));
		m_142416_(new ButtonClearPatterns(f_97735_+171, f_97736_+56));
	}

	@Override
	protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
		IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
		for(int i = 0; i < 9; ++i) {
			for(int j = 0; j < 9; ++j) {
				Vec3i color = recipeType.getSlotColor(i*9+j);
				RenderSystem.setShaderColor(color.m_123341_()/255F, color.m_123342_()/255F, color.m_123343_()/255F, 1F);
				graphics.m_280163_(BACKGROUND, f_97735_+8+j*18, f_97736_+57+i*18, 258, 0, 16, 16, 512, 512);
			}
		}
		for(int i = 0; i < 3; ++i) {
			for(int j = 0; j < 3; ++j) {
				int slotIndex = 81+(i*3+j == 4 ? 0 : i*3+j < 4 ? i*3+j+1 : i*3+j);
				Vec3i color = recipeType.getSlotColor(slotIndex);
				RenderSystem.setShaderColor(color.m_123341_()/255F, color.m_123342_()/255F, color.m_123343_()/255F, 1F);
				graphics.m_280163_(BACKGROUND, f_97735_+198+j*18, f_97736_+111+i*18, 258, 0, 16, 16, 512, 512);
			}
		}
		RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
	}

	@Override
	protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		graphics.m_280056_(f_96547_, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040, false);
		graphics.m_280056_(f_96547_, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040, false);
		String str = menu.patternItemHandler.recipeType.getShortDisplayName().getString();
		graphics.m_280056_(f_96547_, str, 212 - f_96547_.m_92895_(str)/2, 64, 0x404040, false);
		super.m_280003_(graphics, mouseX, mouseY);
		IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
		if(recipeType != null) {
			Object rep = recipeType.getRepresentation();
			if(rep instanceof TextureAtlasSprite sprite) {
				RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
				RenderSystem.setShaderTexture(0, InventoryMenu.f_39692_);
				graphics.m_280159_(204, 75, 0, 16, 16, sprite);
			}
			if(rep instanceof ItemStack stack) {
				RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
				graphics.m_280480_(stack, 204, 75);
			}
		}
	}

	@Override
	public int getItemAmountSpecificationLimit(Slot slot) {
		int stackLimit = slot.m_7993_().m_41741_();
		return slot.f_40219_ > 81 ? Math.max(stackLimit, 999) : stackLimit;
	}

	class ButtonPatternSlot extends AbstractButton {

		int id;

		ButtonPatternSlot(int id, int x, int y) {
			super(x, y, 18, 18, Component.m_237119_());
			this.id = id;
			m_257544_(Tooltip.m_257550_(Component.m_237110_("block.packagedauto.encoder.pattern_slot", String.format("%02d", id))));
		}

		@Override
		public boolean m_198029_() {
			return super.m_198029_() || menu.blockEntity.patternIndex == id;
		}

		@Override
		protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			for(int i = 81; i < 90; ++i) {
				ItemStack stack = menu.blockEntity.patternItemHandlers[id].getStackInSlot(i);
				if(!stack.m_41619_()) {
					RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
					graphics.m_280480_(stack, m_252754_()+1, m_252907_()+1);
					break;
				}
			}
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			PacketHandler.INSTANCE.sendToServer(new SetPatternIndexPacket(id));
			menu.blockEntity.setPatternIndex(id);
			menu.setupSlots();
		}
	}

	class ButtonRecipeType extends AbstractButton {

		final boolean prev;

		ButtonRecipeType(boolean prev, int x, int y) {
			super(x, y, 10, 18, Component.m_237119_());
			this.prev = prev;
			m_257544_(Tooltip.m_257550_(Component.m_237115_("block.packagedauto.encoder.recipe_type."+(prev ? "prev" : "next"))));
		}

		@Override
		protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			graphics.m_280163_(BACKGROUND, m_252754_()+1, m_252907_()+1, prev ? 258 : 266, 48, 8, 16, 512, 512);
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			PacketHandler.INSTANCE.sendToServer(new CycleRecipeTypePacket(prev));
			menu.patternItemHandler.cycleRecipeType(prev);
			menu.setupSlots();
		}
	}

	class ButtonSavePatterns extends AbstractButton {

		ButtonSavePatterns(int x, int y) {
			super(x, y, 36, 18, Component.m_237119_());
			Component line0 = Component.m_237115_("block.packagedauto.encoder.save");
			Component line1 = Component.m_237115_("block.packagedauto.encoder.save.single").m_130940_(ChatFormatting.GRAY);
			m_257544_(Tooltip.m_257550_(ComponentUtils.m_178433_(List.of(line0, line1), Component.m_237113_("\n"))));
		}

		@Override
		protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			graphics.m_280163_(BACKGROUND, m_252754_()+1, m_252907_()+1, 258, 16, 34, 16, 512, 512);
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			boolean single = m_96638_();
			PacketHandler.INSTANCE.sendToServer(new SaveRecipeListPacket(single));
		}
	}

	class ButtonLoadPatterns extends AbstractButton {

		ButtonLoadPatterns(int x, int y) {
			super(x, y, 36, 18, Component.m_237119_());
			Component line0 = Component.m_237115_("block.packagedauto.encoder.load");
			Component line1 = Component.m_237115_("block.packagedauto.encoder.load.single").m_130940_(ChatFormatting.GRAY);
			m_257544_(Tooltip.m_257550_(ComponentUtils.m_178433_(List.of(line0, line1), Component.m_237113_("\n"))));
		}

		@Override
		protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			graphics.m_280163_(BACKGROUND, m_252754_()+1, m_252907_()+1, 258, 32, 34, 16, 512, 512);
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			boolean single = m_96638_();
			PacketHandler.INSTANCE.sendToServer(new LoadRecipeListPacket(single, false));
			menu.blockEntity.loadRecipeList(single, false);
			menu.setupSlots();
		}
	}

	class ButtonClearPatterns extends AbstractButton {

		ButtonClearPatterns(int x, int y) {
			super(x, y, 7, 7, Component.m_237119_());
			Component line0 = Component.m_237115_("block.packagedauto.encoder.clear");
			Component line1 = Component.m_237115_("block.packagedauto.encoder.clear.all").m_130940_(ChatFormatting.GRAY);
			m_257544_(Tooltip.m_257550_(ComponentUtils.m_178433_(List.of(line0, line1), Component.m_237113_("\n"))));
		}

		@Override
		protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			boolean single = !m_96638_();
			PacketHandler.INSTANCE.sendToServer(new LoadRecipeListPacket(single, true));
			menu.blockEntity.loadRecipeList(single, true);
			menu.setupSlots();
		}
	}
}
