package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.menu.PackagerExtensionMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.ChangePackagingPacket;

public class PackagerExtensionScreen extends BaseScreen<PackagerExtensionMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/packager_extension.png");

	public PackagerExtensionScreen(PackagerExtensionMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void m_7856_() {
		m_169413_();
		super.m_7856_();
		m_142416_(new ButtonChangePackaging(f_97735_+98, f_97736_+16));
	}

	@Override
	protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
		graphics.m_280218_(BACKGROUND, f_97735_+102, f_97736_+53, 176, 0, menu.blockEntity.getScaledProgress(22), 16);
		int scaledEnergy = menu.blockEntity.getScaledEnergy(40);
		graphics.m_280218_(BACKGROUND, f_97735_+10, f_97736_+10+40-scaledEnergy, 176, 16+40-scaledEnergy, 12, scaledEnergy);
	}

	@Override
	protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		graphics.m_280056_(f_96547_, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040, false);
		graphics.m_280056_(f_96547_, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040, false);
		if(mouseX-f_97735_ >= 10 && mouseY-f_97736_ >= 10 && mouseX-f_97735_ <= 21 && mouseY-f_97736_ <= 49) {
			graphics.m_280557_(f_96547_, Component.m_237113_(menu.blockEntity.getEnergyStorage().getEnergyStored()+" / "+menu.blockEntity.getEnergyStorage().getMaxEnergyStored()+" FE"), mouseX-f_97735_, mouseY-f_97736_);
		}
		super.m_280003_(graphics, mouseX, mouseY);
	}

	class ButtonChangePackaging extends AbstractButton {

		final Tooltip exactTooltip = Tooltip.m_257550_(PackagerBlockEntity.Mode.EXACT.getTooltip());
		final Tooltip disjointTooltip = Tooltip.m_257550_(PackagerBlockEntity.Mode.DISJOINT.getTooltip());
		final Tooltip firstTooltip = Tooltip.m_257550_(PackagerBlockEntity.Mode.FIRST.getTooltip());

		public ButtonChangePackaging(int x, int y) {
			super(x, y, 16, 18, Component.m_237119_());
		}

		@Override
		public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
			m_257544_(currentTooltip());
			super.m_88315_(graphics, mouseX, mouseY, partialTick);
		}

		@Override
		public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			graphics.m_280218_(BACKGROUND, m_252754_()+1, m_252907_()+2, 176, 56+14*menu.blockEntity.mode.ordinal(), 14, 14);
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			PacketHandler.INSTANCE.sendToServer(ChangePackagingPacket.INSTANCE);
		}

		private Tooltip currentTooltip() {
			return switch(menu.blockEntity.mode) {
			case EXACT -> exactTooltip;
			case DISJOINT -> disjointTooltip;
			case FIRST -> firstTooltip;
			};
		}
	}
}
