package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.block.entity.PackagingProviderBlockEntity;
import thelm.packagedauto.menu.PackagingProviderMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.ChangeBlockingPacket;
import thelm.packagedauto.network.packet.ChangeProvidingPacket;

public class PackagingProviderScreen extends BaseScreen<PackagingProviderMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/packaging_provider.png");

	public PackagingProviderScreen(PackagingProviderMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void m_7856_() {
		m_169413_();
		super.m_7856_();
		m_142416_(new ButtonChangeBlocking(f_97735_+62, f_97736_+34));
		m_142416_(new ButtonChangeProvideDirect(f_97735_+98, f_97736_+34));
		m_142416_(new ButtonChangeProvidePackaging(f_97735_+116, f_97736_+34));
		m_142416_(new ButtonChangeProvideUnpackaging(f_97735_+134, f_97736_+34));
	}

	@Override
	protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		graphics.m_280056_(f_96547_, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040, false);
		graphics.m_280056_(f_96547_, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040, false);
		super.m_280003_(graphics, mouseX, mouseY);
	}

	class ButtonChangeBlocking extends AbstractButton {

		final Tooltip trueTooltip = Tooltip.m_257550_(Component.m_237115_("block.packagedauto.unpackager.blocking.true"));
		final Tooltip falseTooltip = Tooltip.m_257550_(Component.m_237115_("block.packagedauto.unpackager.blocking.false"));

		public ButtonChangeBlocking(int x, int y) {
			super(x, y, 16, 18, Component.m_237119_());
		}

		@Override
		public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
			m_257544_(menu.blockEntity.blocking ? trueTooltip : falseTooltip);
			super.m_88315_(graphics, mouseX, mouseY, partialTick);
		}

		@Override
		public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			RenderSystem.setShaderTexture(0, BACKGROUND);
			graphics.m_280218_(BACKGROUND, m_252754_()+1, m_252907_()+2, 176, menu.blockEntity.blocking ? 14 : 0, 14, 14);
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			PacketHandler.INSTANCE.sendToServer(ChangeBlockingPacket.INSTANCE);
		}
	}

	class ButtonChangeProvideDirect extends AbstractButton {

		final Tooltip trueTooltip = Tooltip.m_257550_(Component.m_237115_("block.packagedauto.packaging_provider.direct.true"));
		final Tooltip falseTooltip = Tooltip.m_257550_(Component.m_237115_("block.packagedauto.packaging_provider.direct.false"));

		public ButtonChangeProvideDirect(int x, int y) {
			super(x, y, 16, 18, Component.m_237119_());
		}

		@Override
		public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
			m_257544_(menu.blockEntity.provideDirect ? trueTooltip : falseTooltip);
			super.m_88315_(graphics, mouseX, mouseY, partialTick);
		}

		@Override
		public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			RenderSystem.setShaderTexture(0, BACKGROUND);
			graphics.m_280218_(BACKGROUND, m_252754_()+1, m_252907_()+2, 176, menu.blockEntity.provideDirect ? 42 : 28, 14, 14);
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			PacketHandler.INSTANCE.sendToServer(new ChangeProvidingPacket(PackagingProviderBlockEntity.Type.DIRECT));
		}
	}

	class ButtonChangeProvidePackaging extends AbstractButton {

		final Tooltip trueTooltip = Tooltip.m_257550_(Component.m_237115_("block.packagedauto.packaging_provider.packaging.true"));
		final Tooltip falseTooltip = Tooltip.m_257550_(Component.m_237115_("block.packagedauto.packaging_provider.packaging.false"));

		public ButtonChangeProvidePackaging(int x, int y) {
			super(x, y, 16, 18, Component.m_237119_());
		}

		@Override
		public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
			m_257544_(menu.blockEntity.providePackaging ? trueTooltip : falseTooltip);
			super.m_88315_(graphics, mouseX, mouseY, partialTick);
		}

		@Override
		public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			RenderSystem.setShaderTexture(0, BACKGROUND);
			graphics.m_280218_(BACKGROUND, m_252754_()+1, m_252907_()+2, 176, menu.blockEntity.providePackaging ? 70 : 56, 14, 14);
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			PacketHandler.INSTANCE.sendToServer(new ChangeProvidingPacket(PackagingProviderBlockEntity.Type.PACKAGING));
		}
	}

	class ButtonChangeProvideUnpackaging extends AbstractButton {

		final Tooltip trueTooltip = Tooltip.m_257550_(Component.m_237115_("block.packagedauto.packaging_provider.unpackaging.true"));
		final Tooltip falseTooltip = Tooltip.m_257550_(Component.m_237115_("block.packagedauto.packaging_provider.unpackaging.false"));

		public ButtonChangeProvideUnpackaging(int x, int y) {
			super(x, y, 16, 18, Component.m_237119_());
		}

		@Override
		public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
			m_257544_(menu.blockEntity.provideUnpackaging ? trueTooltip : falseTooltip);
			super.m_88315_(graphics, mouseX, mouseY, partialTick);
		}

		@Override
		public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			RenderSystem.setShaderTexture(0, BACKGROUND);
			graphics.m_280218_(BACKGROUND, m_252754_()+1, m_252907_()+2, 176, menu.blockEntity.provideUnpackaging ? 98 : 84, 14, 14);
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			PacketHandler.INSTANCE.sendToServer(new ChangeProvidingPacket(PackagingProviderBlockEntity.Type.UNPACKAGING));
		}
	}
}
