package thelm.packagedauto.client.screen;

import java.util.List;

import com.mojang.blaze3d.systems.RenderSystem;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity.PackageTracker;
import thelm.packagedauto.menu.UnpackagerMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.ChangeBlockingPacket;
import thelm.packagedauto.network.packet.EjectTrackerPacket;
import thelm.packagedauto.network.packet.TrackerCountPacket;

public class UnpackagerScreen extends BaseScreen<UnpackagerMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/unpackager.png");

	public UnpackagerScreen(UnpackagerMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void m_7856_() {
		m_169413_();
		super.m_7856_();
		m_142416_(new ButtonChangeBlocking(f_97735_+98, f_97736_+16));
		for(int i = 0; i < 10; ++i) {
			m_142416_(new ButtonTracker(i, f_97735_+115, f_97736_+16+6*i));
		}
		m_142416_(new ButtonTrackerCount(true, f_97735_+98, f_97736_+34));
		m_142416_(new ButtonTrackerCount(false, f_97735_+106, f_97736_+34));
	}

	@Override
	protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
		int scaledEnergy = menu.blockEntity.getScaledEnergy(40);
		graphics.m_280218_(BACKGROUND, f_97735_+10, f_97736_+10+40-scaledEnergy, 176, 40-scaledEnergy, 12, scaledEnergy);
		for(int i = 0; i < menu.blockEntity.trackers.length; ++i) {
			PackageTracker tracker = menu.blockEntity.trackers[i];
			for(int j = 0; j < 9; ++j) {
				if(j < tracker.amount) {
					if(tracker.received.getBoolean(j)) {
						graphics.m_280218_(BACKGROUND, f_97735_+115+6*j, f_97736_+16+6*i, 176, 45, 6, 5);
					}
					else {
						graphics.m_280218_(BACKGROUND, f_97735_+115+6*j, f_97736_+16+6*i, 176, 40, 6, 5);
					}
				}
				else if(i < menu.blockEntity.trackerCount) {
					graphics.m_280218_(BACKGROUND, f_97735_+115+6*j, f_97736_+16+6*i, 182, 45, 6, 5);
				}
				else {
					graphics.m_280218_(BACKGROUND, f_97735_+115+6*j, f_97736_+16+6*i, 182, 40, 6, 5);
				}
			}
		}
	}

	@Override
	protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		graphics.m_280056_(f_96547_, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040, false);
		graphics.m_280056_(f_96547_, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040, false);
		if(mouseX-f_97735_ >= 10 && mouseY-f_97736_ >= 10 && mouseX-f_97735_ <= 21 && mouseY-f_97736_ <= 49) {
			graphics.m_280557_(f_96547_, Component.m_237113_(menu.blockEntity.getEnergyStorage().getEnergyStored()+" / "+menu.blockEntity.getEnergyStorage().getMaxEnergyStored()+" FE"), mouseX-f_97735_, mouseY-f_97736_);
		}
		super.m_280003_(graphics, mouseX, mouseY);
	}

	class ButtonChangeBlocking extends AbstractButton {

		final Tooltip trueTooltip = Tooltip.m_257550_(Component.m_237115_("block.packagedauto.unpackager.blocking.true"));
		final Tooltip falseTooltip = Tooltip.m_257550_(Component.m_237115_("block.packagedauto.unpackager.blocking.false"));

		public ButtonChangeBlocking(int x, int y) {
			super(x, y, 16, 18, Component.m_237119_());
		}

		@Override
		public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
			m_257544_(menu.blockEntity.blocking ? trueTooltip : falseTooltip);
			super.m_88315_(graphics, mouseX, mouseY, partialTick);
		}

		@Override
		public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			RenderSystem.setShaderTexture(0, BACKGROUND);
			graphics.m_280218_(BACKGROUND, m_252754_()+1, m_252907_()+2, 176, menu.blockEntity.blocking ? 64 : 50, 14, 14);
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			PacketHandler.INSTANCE.sendToServer(ChangeBlockingPacket.INSTANCE);
		}
	}

	class ButtonTracker extends AbstractButton {

		final int id;

		ButtonTracker(int id, int x, int y) {
			super(x, y, 54, 5, Component.m_237119_());
			this.id = id;
			Component line0 = Component.m_237110_("block.packagedauto.unpackager.tracker", id);
			Component line1 = Component.m_237115_("block.packagedauto.unpackager.tracker.eject").m_130940_(ChatFormatting.GRAY);
			m_257544_(Tooltip.m_257550_(ComponentUtils.m_178433_(List.of(line0, line1), Component.m_237113_("\n"))));
		}

		@Override
		protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			if(m_96638_()) {
				PacketHandler.INSTANCE.sendToServer(new EjectTrackerPacket(id));
			}
		}
	}

	class ButtonTrackerCount extends AbstractButton {

		final boolean decrease;

		public ButtonTrackerCount(boolean decrease, int x, int y) {
			super(x, y, 8, 18, Component.m_237119_());
			this.decrease = decrease;
			m_257544_(Tooltip.m_257550_(Component.m_237115_("block.packagedauto.unpackager.tracker."+(decrease ? "decrease" : "increase"))));
		}

		@Override
		public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
			super.m_87963_(graphics, mouseX, mouseY, partialTicks);
			RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
			RenderSystem.setShaderTexture(0, BACKGROUND);
			graphics.m_280218_(BACKGROUND, m_252754_()+1, m_252907_()+2, decrease ? 176 : 182, 78, 6, 14);
		}

		@Override
		public void m_168797_(NarrationElementOutput narrationElementOutput) {}

		@Override
		public void m_5691_() {
			PacketHandler.INSTANCE.sendToServer(new TrackerCountPacket(decrease));
		}
	}
}
