package thelm.packagedauto.integration.appeng.blockentity;

import java.util.List;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.crafting.IPatternDetails;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.block.PackagerBlock;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternDetails;

public class AEPackagerBlockEntity extends PackagerBlockEntity implements IInWorldGridNodeHost, IGridNodeListener<AEPackagerBlockEntity>, IActionHost, ICraftingProvider {

	public IActionSource source;
	public IManagedGridNode gridNode;

	public AEPackagerBlockEntity(BlockPos pos, BlockState state) {
		super(pos, state);
		source = IActionSource.ofMachine(this);
	}

	@Override
	public void tick() {
		if(firstTick) {
			getMainNode().create(f_58857_, f_58858_);
		}
		super.tick();
		if(drawMEEnergy && !f_58857_.f_46443_ && f_58857_.m_46467_() % refreshInterval == 0) {
			chargeMEEnergy();
		}
	}

	@Override
	public void m_7651_() {
		super.m_7651_();
		if(gridNode != null) {
			gridNode.destroy();
		}
	}

	@Override
	public void onChunkUnloaded() {
		super.onChunkUnloaded();
		if(gridNode != null) {
			gridNode.destroy();
		}
	}

	@Override
	public IGridNode getGridNode(Direction dir) {
		return getActionableNode();
	}

	@Override
	public AECableType getCableConnectionType(Direction dir) {
		return AECableType.SMART;
	}

	@Override
	public void onSaveChanges(AEPackagerBlockEntity nodeOwner, IGridNode node) {
		m_6596_();
	}

	@Override
	public void onStateChanged(AEPackagerBlockEntity nodeOwner, IGridNode node, State state) {
		if(state == State.POWER || state == State.CHANNEL) {
			postPatternChange();
		}
	}

	public IManagedGridNode getMainNode() {
		if(gridNode == null) {
			gridNode = GridHelper.createManagedNode(this, this);
			gridNode.setTagName("Node");
			gridNode.setVisualRepresentation(PackagerBlock.INSTANCE);
			gridNode.setGridColor(AEColor.TRANSPARENT);
			gridNode.setFlags(GridFlags.REQUIRE_CHANNEL);
			gridNode.addService(ICraftingProvider.class, this);
			gridNode.setIdlePowerUsage(1);
			gridNode.setInWorldNode(true);
			if(ownerUUID != null && f_58857_ instanceof ServerLevel) {
				gridNode.setOwningPlayerId(IPlayerRegistry.getMapping(f_58857_).getPlayerId(ownerUUID));
			}
		}
		return gridNode;
	}

	@Override
	public IGridNode getActionableNode() {
		return getMainNode().getNode();
	}

	@Override
	public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
		if(getMainNode().isActive() && !isBusy() && patternDetails instanceof PackageCraftingPatternDetails pattern) {
			ItemStack outputStack = pattern.pattern.getOutput();
			List<ItemStack> inputs = pattern.pattern.getInputs();
			if(canPushPattern()) {
				ItemStack slotStack = itemHandler.getStackInSlot(9);
				if(slotStack.m_41619_() || ItemStack.m_150942_(slotStack, outputStack) && slotStack.m_41613_()+1 <= outputStack.m_41741_()) {
					currentPattern = pattern.pattern;
					lockPattern = true;
					for(int i = 0; i < inputs.size(); ++i) {
						itemHandler.setStackInSlot(i, inputs.get(i).m_41777_());
					}
					return true;
				}
			}
			for(BlockPos posP : BlockPos.m_121940_(f_58858_.m_7918_(-1, -1, -1), f_58858_.m_7918_(1, 1, 1))) {
				BlockEntity blockEntity = f_58857_.m_7702_(posP);
				if(blockEntity instanceof AEPackagerExtensionBlockEntity extension) {
					if(extension.packager == this && extension.getMainNode().isActive() && getMainNode().getGrid() == extension.getMainNode().getGrid() && extension.canPushPattern()) {
						ItemStack slotStack = extension.getItemHandler().getStackInSlot(9);
						if(slotStack.m_41619_() || ItemStack.m_150942_(slotStack, outputStack) && slotStack.m_41613_()+1 <= outputStack.m_41741_()) {
							extension.currentPattern = pattern.pattern;
							extension.lockPattern = true;
							for(int i = 0; i < inputs.size(); ++i) {
								itemHandler.setStackInSlot(i, inputs.get(i).m_41777_());
							}
							return true;
						}
					}
				}
			}
		}
		return false;
	}

	@Override
	public boolean isBusy() {
		if(canPushPattern()) {
			return false;
		}
		for(BlockPos posP : BlockPos.m_121940_(f_58858_.m_7918_(-1, -1, -1), f_58858_.m_7918_(1, 1, 1))) {
			BlockEntity blockEntity = f_58857_.m_7702_(posP);
			if(blockEntity instanceof AEPackagerExtensionBlockEntity extension) {
				if(extension.packager == this && getMainNode().getGrid() == extension.getMainNode().getGrid() && extension.canPushPattern()) {
					return false;
				}
			}
		}
		return true;
	}

	@Override
	public List<IPatternDetails> getAvailablePatterns() {
		if(getMainNode().isActive()) {
			return patternList.stream().<IPatternDetails>map(pattern->new PackageCraftingPatternDetails(pattern)).toList();
		}
		else {
			return List.of();
		}
	}


	@Override
	protected void ejectItem() {
		if(getMainNode().isActive()) {
			IGrid grid = getMainNode().getGrid();
			IStorageService storageService = grid.getStorageService();
			IEnergyService energyService = grid.getEnergyService();
			MEStorage inventory = storageService.getInventory();
			ItemStack is = itemHandler.getStackInSlot(9);
			AEItemKey key = AEItemKey.of(is);
			int count = is.m_41613_();
			int inserted = (int)StorageHelper.poweredInsert(energyService, inventory, key, count, source, Actionable.MODULATE);
			if(inserted == count) {
				itemHandler.setStackInSlot(9, ItemStack.f_41583_);
			}
			else {
				itemHandler.setStackInSlot(9, key.toStack(count-inserted));
			}
		}
		else {
			super.ejectItem();
		}
	}

	@Override
	public void postPatternChange() {
		ICraftingProvider.requestUpdate(getMainNode());
	}

	protected void chargeMEEnergy() {
		if(getMainNode().isActive()) {
			IGrid grid = getMainNode().getGrid();
			IEnergyService energyService = grid.getEnergyService();
			double conversion = PowerUnits.FE.convertTo(PowerUnits.AE, 1);
			int request = Math.min(energyStorage.getMaxReceive(), energyStorage.getMaxEnergyStored()-energyStorage.getEnergyStored());
			double available = energyService.extractAEPower((request+0.5)*conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
			int extract = (int)(available/conversion);
			energyService.extractAEPower(extract*conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
			energyStorage.receiveEnergy(extract, false);
		}
	}

	@Override
	public void m_142466_(CompoundTag nbt) {
		super.m_142466_(nbt);
		if(nbt.m_128441_("Node")) {
			getMainNode().loadFromNBT(nbt);
		}
	}

	@Override
	public void m_183515_(CompoundTag nbt) {
		super.m_183515_(nbt);
		if(gridNode != null) {
			gridNode.saveToNBT(nbt);
		}
	}
}
