package thelm.packagedauto.menu;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.OptionalIntDataSlot;

//Large portions of code are taken from CoFHCore
public class BaseMenu<T extends BaseBlockEntity> extends AbstractContainerMenu {

	public final T blockEntity;
	public final Inventory inventory;
	public final BaseItemHandler<?> itemHandler;

	public BaseMenu(MenuType<?> menuType, int windowId, Inventory inventory, T blockEntity) {
		super(menuType, windowId);
		this.blockEntity = blockEntity;
		this.inventory = inventory;
		itemHandler = blockEntity != null ? blockEntity.getItemHandler() : new BaseItemHandler<>(null, 0);
		m_38884_(itemHandler);
	}

	public int getPlayerInvX() {
		return 8;
	}

	public int getPlayerInvY() {
		return 84;
	}

	public void setupPlayerInventory() {
		int xOffset = getPlayerInvX();
		int yOffset = getPlayerInvY();
		for(int i = 0; i < 3; i++) {
			for(int j = 0; j < 9; j++) {
				m_38897_(new Slot(inventory, j+i*9+9, xOffset+j*18, yOffset+i*18));
			}
		}
		for(int i = 0; i < 9; i++) {
			m_38897_(new Slot(inventory, i, xOffset+i*18, yOffset+58));
		}
	}

	@Override
	protected void m_38884_(ContainerData array) {
		for(int i = 0; i < array.m_6499_(); ++i) {
			m_38895_(OptionalIntDataSlot.of(array, i));
		}
	}

	public int getSizeInventory() {
		return itemHandler.getSlots();
	}

	public boolean supportsShiftClick(Player player, int slotIndex) {
		return true;
	}

	public boolean performMerge(Player player, int slotIndex, ItemStack stack) {
		int invBase = getSizeInventory();
		int invFull = f_38839_.size();
		if(slotIndex < invBase) {
			return m_38903_(stack, invBase, invFull, true);
		}
		return m_38903_(stack, 0, invBase, false);
	}

	@Override
	public ItemStack m_7648_(Player player, int slotIndex) {
		if(!supportsShiftClick(player, slotIndex)) {
			return ItemStack.f_41583_;
		}
		ItemStack stack = ItemStack.f_41583_;
		Slot slot = f_38839_.get(slotIndex);
		if(slot != null && slot.m_6657_()) {
			ItemStack stackInSlot = slot.m_7993_();
			stack = stackInSlot.m_41777_();
			if(!performMerge(player, slotIndex, stackInSlot)) {
				return ItemStack.f_41583_;
			}
			slot.m_40234_(stackInSlot, stack);
			if(stackInSlot.m_41613_() <= 0) {
				slot.m_5852_(ItemStack.f_41583_);
			}
			else {
				slot.m_5852_(stackInSlot);
			}
			if(stackInSlot.m_41613_() == stack.m_41613_()) {
				return ItemStack.f_41583_;
			}
			slot.m_142406_(player, stackInSlot);
		}
		return stack;
	}

	@Override
	protected boolean m_38903_(ItemStack stack, int slotMin, int slotMax, boolean ascending) {
		boolean successful = false;
		int i = !ascending ? slotMin : slotMax - 1;
		int iterOrder = !ascending ? 1 : -1;
		Slot slot;
		ItemStack existingStack;
		if(stack.m_41753_()) {
			while(stack.m_41613_() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
				slot = f_38839_.get(i);
				if(slot instanceof FalseCopySlot) {
					i += iterOrder;
					continue;
				}
				existingStack = slot.m_7993_();
				if(!existingStack.m_41619_()) {
					int maxStack = Math.min(stack.m_41741_(), slot.m_6641_());
					int rmv = Math.min(maxStack, stack.m_41613_());
					if(slot.m_5857_(MiscHelper.INSTANCE.cloneStack(stack, rmv)) && ItemStack.m_150942_(stack, existingStack)) {
						int existingSize = existingStack.m_41613_() + stack.m_41613_();
						if(existingSize <= maxStack) {
							stack.m_41764_(0);
							existingStack.m_41764_(existingSize);
							slot.m_5852_(existingStack);
							successful = true;
						}
						else if(existingStack.m_41613_() < maxStack) {
							stack.m_41774_(maxStack - existingStack.m_41613_());
							existingStack.m_41764_(maxStack);
							slot.m_5852_(existingStack);
							successful = true;
						}
					}
				}
				i += iterOrder;
			}
		}
		if(stack.m_41613_() > 0) {
			i = !ascending ? slotMin : slotMax - 1;
			while(stack.m_41613_() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
				slot = f_38839_.get(i);
				if(slot instanceof FalseCopySlot) {
					i += iterOrder;
					continue;
				}
				existingStack = slot.m_7993_();
				if(existingStack.m_41619_()) {
					int maxStack = Math.min(stack.m_41741_(), slot.m_6641_());
					int rmv = Math.min(maxStack, stack.m_41613_());
					if(slot.m_5857_(MiscHelper.INSTANCE.cloneStack(stack, rmv))) {
						existingStack = stack.m_41620_(rmv);
						slot.m_5852_(existingStack);
						successful = true;
					}
				}
				i += iterOrder;
			}
		}
		return successful;
	}

	@Override
	public void m_150399_(int slotId, int mouseButton, ClickType clickType, Player player) {
		if(slotId >= 0 && f_38839_.get(slotId) instanceof FalseCopySlot slot) {
			if(clickType == ClickType.QUICK_MOVE) {
				slot.m_5852_(ItemStack.f_41583_);
			}
			else {
				ItemStack toPut = m_142621_().m_41777_();
				ItemStack stack = slot.m_7993_().m_41777_();
				switch(mouseButton) {
				case 0 -> slot.m_5852_(toPut);
				case 1 -> {
					if(stack.m_41619_()) {
						if(!toPut.m_41619_()) {
							toPut.m_41764_(1);
						}
						slot.m_5852_(toPut);
					}
					else if(ItemStack.m_150942_(stack, toPut) && stack.m_41613_() < stack.m_41741_()) {
						stack.m_41769_(1);
						slot.m_5852_(stack);
					}
					else {
						stack.m_41774_(1);
						slot.m_5852_(stack);
					}
				}
				}
			}
		}
		else {
			super.m_150399_(slotId, mouseButton, clickType, player);
		}
	}

	@Override
	public boolean m_6875_(Player player) {
		if(blockEntity != null) {
			return Container.m_272074_(blockEntity, player);
		}
		return true;
	}
}
