package thelm.packagedauto.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.DistributorBlockEntity;

public class DistributorBlock extends BaseBlock {

	public static final DistributorBlock INSTANCE = new DistributorBlock();
	public static final Item ITEM_INSTANCE = new BlockItem(INSTANCE, new Item.Properties().m_41491_(PackagedAuto.CREATIVE_TAB)).setRegistryName("packagedauto:distributor");

	protected DistributorBlock() {
		super(BlockBehaviour.Properties.m_60939_(Material.f_76279_).m_60913_(15F, 25F).m_60918_(SoundType.f_56743_));
		setRegistryName("packagedauto:distributor");
	}

	@Override
	public DistributorBlockEntity m_142194_(BlockPos pos, BlockState state) {
		return DistributorBlockEntity.TYPE_INSTANCE.m_155264_(pos, state);
	}

	@Override
	public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
		return BaseBlockEntity::tick;
	}

	@Override
	public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
		if(player.m_6144_()) {
			BlockEntity blockEntity = level.m_7702_(pos);
			if(blockEntity instanceof DistributorBlockEntity distributor) {
				if(!level.f_46443_) {
					distributor.sendPreview((ServerPlayer)player);
				}
				return InteractionResult.SUCCESS;
			}
		}
		return super.m_6227_(state, level, pos, player, hand, hitResult);
	}

	@Override
	public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
		if(state.m_60734_() != newState.m_60734_()) {
			if(level.m_7702_(pos) instanceof DistributorBlockEntity distributor) {
				for(Int2ObjectMap.Entry<ItemStack> entry : distributor.pending.int2ObjectEntrySet()) {
					Containers.m_18992_(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), entry.getValue());
				}
			}
		}
		super.m_6810_(state, level, pos, newState, isMoving);
	}
}
