package thelm.packagedauto.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagingProviderBlockEntity;

public class PackagingProviderBlock extends BaseBlock {

	public static final PackagingProviderBlock INSTANCE = new PackagingProviderBlock();
	public static final Item ITEM_INSTANCE = new BlockItem(INSTANCE, new Item.Properties().m_41491_(ModList.get().isLoaded("ae2") ? PackagedAuto.CREATIVE_TAB : null)).setRegistryName("packagedauto:packaging_provider");

	protected PackagingProviderBlock() {
		super(BlockBehaviour.Properties.m_60939_(Material.f_76279_).m_60913_(15F, 25F).m_60918_(SoundType.f_56743_));
		setRegistryName("packagedauto:packaging_provider");
	}

	@Override
	public PackagingProviderBlockEntity m_142194_(BlockPos pos, BlockState state) {
		return PackagingProviderBlockEntity.TYPE_INSTANCE.m_155264_(pos, state);
	}

	@Override
	public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
		return BaseBlockEntity::tick;
	}

	@Override
	public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
		if(state.m_60734_() != newState.m_60734_()) {
			if(level.m_7702_(pos) instanceof PackagingProviderBlockEntity provider) {
				if(provider.currentPattern != null) {
					for(ItemStack stack : provider.currentPattern.getInputs()) {
						if(!stack.m_41619_()) {
							Containers.m_18992_(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stack);
						}
					}
				}
				if(!provider.toSend.isEmpty()) {
					for(ItemStack stack : provider.toSend) {
						if(!stack.m_41619_()) {
							Containers.m_18992_(level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), stack);
						}
					}
				}
			}
		}
		super.m_6810_(state, level, pos, newState, isMoving);
	}

	@Override
	public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
		level.m_141902_(pos, PackagingProviderBlockEntity.TYPE_INSTANCE).ifPresent(PackagingProviderBlockEntity::updatePowered);
	}
}
