package thelm.packagedauto.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import com.google.common.collect.Lists;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.PackagerBlock;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.blockentity.AEPackagerBlockEntity;
import thelm.packagedauto.inventory.PackagerItemHandler;
import thelm.packagedauto.item.RecipeHolderItem;
import thelm.packagedauto.menu.PackagerMenu;
import thelm.packagedauto.util.MiscHelper;

public class PackagerBlockEntity extends BaseBlockEntity implements ISettingsCloneable {

	public static final BlockEntityType<PackagerBlockEntity> TYPE_INSTANCE = (BlockEntityType<PackagerBlockEntity>)BlockEntityType.Builder.
			m_155273_(MiscHelper.INSTANCE.<BlockEntityType.BlockEntitySupplier<PackagerBlockEntity>>conditionalSupplier(
					()->ModList.get().isLoaded("ae2"),
					()->()->AEPackagerBlockEntity::new, ()->()->PackagerBlockEntity::new).get(),
					PackagerBlock.INSTANCE).
			m_58966_(null).setRegistryName("packagedauto:packager");

	public static int energyCapacity = 5000;
	public static int energyReq = 500;
	public static int energyUsage = 100;
	public static int refreshInterval = 4;
	public static boolean drawMEEnergy = true;

	public boolean firstTick = true;
	public boolean isWorking = false;
	public int remainingProgress = 0;
	public List<IPackagePattern> patternList = new ArrayList<>();
	public IPackagePattern currentPattern;
	public boolean lockPattern = false;
	public Mode mode = Mode.EXACT;
	public boolean disjoint = false;
	public boolean powered = false;

	public PackagerBlockEntity(BlockPos pos, BlockState state) {
		super(TYPE_INSTANCE, pos, state);
		setItemHandler(new PackagerItemHandler(this));
		setEnergyStorage(new EnergyStorage(this, energyCapacity));
	}

	@Override
	protected Component getDefaultName() {
		return new TranslatableComponent("block.packagedauto.packager");
	}

	@Override
	public String getConfigTypeName() {
		return "block.packagedauto.packager";
	}

	@Override
	public void tick() {
		if(firstTick) {
			firstTick = false;
			if(!f_58857_.f_46443_) {
				postPatternChange();
			}
			updatePowered();
		}
		if(!f_58857_.f_46443_) {
			if(isWorking) {
				tickProcess();
				if(remainingProgress <= 0 && isInputValid()) {
					finishProcess();
					if(!itemHandler.getStackInSlot(9).m_41619_()) {
						ejectItem();
					}
					if(!canStart()) {
						endProcess();
					}
					else {
						startProcess();
					}
				}
			}
			else if(f_58857_.m_46467_() % refreshInterval == 0) {
				if(canStart()) {
					startProcess();
					tickProcess();
					isWorking = true;
				}
			}
			chargeEnergy();
			if(f_58857_.m_46467_() % refreshInterval == 0) {
				if(!itemHandler.getStackInSlot(9).m_41619_()) {
					ejectItem();
				}
			}
		}
	}

	protected static Ingredient getIngredient(ItemStack stack) {
		return stack.m_41782_() ? NBTIngredient.of(stack) : Ingredient.m_43927_(stack);
	}

	public boolean isInputValid() {
		if(currentPattern == null) {
			getPattern();
		}
		if(currentPattern == null) {
			return false;
		}
		List<ItemStack> input = itemHandler.getStacks().subList(0, 9).stream().filter(stack->!stack.m_41619_()).toList();
		if(input.isEmpty()) {
			return false;
		}
		if(!lockPattern && disjoint) {
			return MiscHelper.INSTANCE.removeExactSet(input, currentPattern.getInputs(), true);
		}
		List<Ingredient> matchers = Lists.transform(currentPattern.getInputs(), PackagerBlockEntity::getIngredient);
		int[] matches = RecipeMatcher.findMatches(input, matchers);
		if(matches == null) {
			return false;
		}
		for(int i = 0; i < matches.length; ++i) {
			if(input.get(i).m_41613_() < currentPattern.getInputs().get(matches[i]).m_41613_()) {
				return false;
			}
		}
		return true;
	}

	protected boolean canStart() {
		getPattern();
		if(currentPattern == null) {
			return false;
		}
		if(!isInputValid()) {
			return false;
		}
		ItemStack slotStack = itemHandler.getStackInSlot(9);
		ItemStack outputStack = currentPattern.getOutput();
		return slotStack.m_41619_() || ItemStack.m_150942_(slotStack, outputStack) && slotStack.m_41613_()+1 <= outputStack.m_41741_();
	}

	protected boolean canFinish() {
		return remainingProgress <= 0 && isInputValid();
	}

	protected void getPattern() {
		if(currentPattern != null && lockPattern) {
			return;
		}
		lockPattern = false;
		currentPattern = null;
		if(powered) {
			return;
		}
		List<ItemStack> input = itemHandler.getStacks().subList(0, 9).stream().filter(stack->!stack.m_41619_()).toList();
		if(input.isEmpty()) {
			return;
		}
		for(IPackagePattern pattern : patternList) {
			if(disjoint) {
				if(MiscHelper.INSTANCE.removeExactSet(input, pattern.getInputs(), true)) {
					currentPattern = pattern;
					return;
				}
			}
			else {
				List<Ingredient> matchers = Lists.transform(pattern.getInputs(), PackagerBlockEntity::getIngredient);
				int[] matches = RecipeMatcher.findMatches(input, matchers);
				if(matches != null) {
					currentPattern = pattern;
					return;
				}
			}
		}
	}

	protected void tickProcess() {
		int energy = energyStorage.extractEnergy(Math.min(energyUsage, remainingProgress), false);
		remainingProgress -= energy;
	}

	protected void finishProcess() {
		if(currentPattern == null) {
			getPattern();
		}
		if(currentPattern == null) {
			endProcess();
			return;
		}
		List<ItemStack> input = itemHandler.getStacks().subList(0, 9).stream().filter(stack->!stack.m_41619_()).toList();
		if(input.isEmpty()) {
			endProcess();
			return;
		}
		if(!lockPattern && disjoint) {
			if(!MiscHelper.INSTANCE.removeExactSet(input, currentPattern.getInputs(), true)) {
				endProcess();
				return;
			}
			if(itemHandler.getStackInSlot(9).m_41619_()) {
				itemHandler.setStackInSlot(9, currentPattern.getOutput());
			}
			else if(itemHandler.getStackInSlot(9).m_41720_() instanceof IPackageItem) {
				itemHandler.getStackInSlot(9).m_41769_(1);
			}
			else {
				endProcess();
				return;
			}
			MiscHelper.INSTANCE.removeExactSet(input, currentPattern.getInputs(), false);
		}
		else {
			List<Ingredient> matchers = Lists.transform(currentPattern.getInputs(), PackagerBlockEntity::getIngredient);
			int[] matches = RecipeMatcher.findMatches(input, matchers);
			if(matches == null) {
				endProcess();
				return;
			}
			if(itemHandler.getStackInSlot(9).m_41619_()) {
				itemHandler.setStackInSlot(9, currentPattern.getOutput());
			}
			else if(itemHandler.getStackInSlot(9).m_41720_() instanceof IPackageItem) {
				itemHandler.getStackInSlot(9).m_41769_(1);
			}
			else {
				endProcess();
				return;
			}
			for(int i = 0; i < matches.length; ++i) {
				input.get(i).m_41774_(currentPattern.getInputs().get(matches[i]).m_41613_());
			}
		}
		for(int i = 0; i < 9; ++i) {
			if(itemHandler.getStackInSlot(i).m_41619_()) {
				itemHandler.setStackInSlot(i, ItemStack.f_41583_);
			}
		}
	}

	protected void startProcess() {
		remainingProgress = energyReq;
		m_6596_();
	}

	public void endProcess() {
		remainingProgress = 0;
		isWorking = false;
		lockPattern = false;
		m_6596_();
	}

	protected void ejectItem() {
		for(Direction direction : Direction.values()) {
			if(f_58857_.m_7702_(f_58858_.m_142300_(direction)) instanceof UnpackagerBlockEntity unpackager) {
				ItemStack stack = itemHandler.getStackInSlot(9);
				if(!stack.m_41619_()) {
					ItemStack stackRem = ItemHandlerHelper.insertItem(unpackager.itemHandler, stack, false);
					itemHandler.setStackInSlot(9, stackRem);
				}
			}
		}
	}

	protected void chargeEnergy() {
		ItemStack energyStack = itemHandler.getStackInSlot(11);
		if(energyStack.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
			int energyRequest = Math.min(energyStorage.getMaxReceive(), energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored());
			energyStorage.receiveEnergy(energyStack.getCapability(CapabilityEnergy.ENERGY).resolve().get().extractEnergy(energyRequest, false), false);
			if(energyStack.m_41613_() <= 0) {
				itemHandler.setStackInSlot(11, ItemStack.f_41583_);
			}
		}
	}

	public void updatePowered() {
		if(f_58857_.m_46755_(f_58858_) > 0 != powered) {
			powered = !powered;
			m_6596_();
		}
	}

	@Override
	public int getComparatorSignal() {
		if(isWorking) {
			return 1;
		}
		if(!itemHandler.getStackInSlot(9).m_41619_()) {
			return 15;
		}
		return 0;
	}

	public boolean canPushPattern() {
		return !isWorking && itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::m_41619_);
	}

	public void postPatternChange() {}

	@Override
	public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
		mode = Mode.values()[nbt.m_128445_("Mode")];
		Component message = null;
		if(nbt.m_128441_("Recipes")) {
			f:if(itemHandler.getStackInSlot(10).m_41619_()) {
				Inventory playerInventory = player.m_150109_();
				for(int i = 0; i < playerInventory.m_6643_(); ++i) {
					ItemStack stack = playerInventory.m_8020_(i);
					if(!stack.m_41619_() && stack.m_150930_(RecipeHolderItem.INSTANCE) && !stack.m_41782_()) {
						ItemStack stackCopy = stack.m_41620_(1);
						IPackageRecipeList recipeListObj = RecipeHolderItem.INSTANCE.getRecipeList(stackCopy);
						List<IPackageRecipeInfo> recipeList = MiscHelper.INSTANCE.loadRecipeList(nbt.m_128437_("Recipes", 10));
						recipeListObj.setRecipeList(recipeList);
						RecipeHolderItem.INSTANCE.setRecipeList(stackCopy, recipeListObj);
						itemHandler.setStackInSlot(10, stackCopy);
						break f;
					}
				}
				message = new TranslatableComponent("block.packagedauto.packager.no_holders");
			}
			else {
				message = new TranslatableComponent("block.packagedauto.packager.holder_present");
			}
		}
		if(message != null) {
			return ISettingsCloneable.Result.partial(message);
		}
		else {
			return ISettingsCloneable.Result.success();
		}
	}

	@Override
	public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
		nbt.m_128344_("Mode", (byte)mode.ordinal());
		ItemStack listStack = itemHandler.getStackInSlot(10);
		if(listStack.m_41720_() instanceof IPackageRecipeListItem recipeListItem) {
			List<IPackageRecipeInfo> recipeList = recipeListItem.getRecipeList(listStack).getRecipeList();
			if(!recipeList.isEmpty()) {
				nbt.m_128365_("Recipes", MiscHelper.INSTANCE.saveRecipeList(new ListTag(), recipeList));
			}
		}
		return ISettingsCloneable.Result.success();
	}

	@Override
	public void m_142466_(CompoundTag nbt) {
		mode = Mode.values()[nbt.m_128445_("Mode")];
		super.m_142466_(nbt);
		isWorking = nbt.m_128471_("Working");
		remainingProgress = nbt.m_128451_("Progress");
		powered = nbt.m_128471_("Powered");
		lockPattern = false;
		currentPattern = null;
		if(nbt.m_128441_("Pattern")) {
			CompoundTag tag = nbt.m_128469_("Pattern");
			IPackageRecipeInfo recipe = MiscHelper.INSTANCE.loadRecipe(tag);
			if(recipe != null) {
				List<IPackagePattern> patterns = recipe.getPatterns();
				byte index = tag.m_128445_("Index");
				if(index >= 0 && index < patterns.size()) {
					currentPattern = patterns.get(index);
					lockPattern = true;
				}
			}
		}
	}

	@Override
	public void m_183515_(CompoundTag nbt) {
		super.m_183515_(nbt);
		nbt.m_128344_("Mode", (byte)mode.ordinal());
		nbt.m_128379_("Working", isWorking);
		nbt.m_128405_("Progress", remainingProgress);
		nbt.m_128379_("Powered", powered);
		if(lockPattern) {
			CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), currentPattern.getRecipeInfo());
			tag.m_128344_("Index", (byte)currentPattern.getIndex());
			nbt.m_128365_("Pattern", tag);
		}
	}

	public void changePackagingMode() {
		mode = Mode.values()[((mode.ordinal()+1) % 3)];
		((PackagerItemHandler)itemHandler).updatePatternList();
		m_6596_();
	}

	@Override
	public void m_6596_() {
		if(isWorking && !isInputValid()) {
			endProcess();
		}
		super.m_6596_();
	}

	public int getScaledEnergy(int scale) {
		if(energyStorage.getMaxEnergyStored() <= 0) {
			return 0;
		}
		return Math.min(scale * energyStorage.getEnergyStored() / energyStorage.getMaxEnergyStored(), scale);
	}

	public int getScaledProgress(int scale) {
		if(remainingProgress <= 0 || energyReq <= 0) {
			return 0;
		}
		return scale * (energyReq-remainingProgress) / energyReq;
	}

	@Override
	public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
		sync(false);
		return new PackagerMenu(windowId, inventory, this);
	}

	public static enum Mode {
		EXACT, DISJOINT, FIRST;

		public Component getTooltip() {
			return new TranslatableComponent("block.packagedauto.packager.mode."+name().toLowerCase(Locale.US));
		}
	}
}
