package thelm.packagedauto.block.entity;

import java.util.ArrayList;
import java.util.List;

import com.google.common.collect.Lists;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.PackagerExtensionBlock;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.blockentity.AEPackagerExtensionBlockEntity;
import thelm.packagedauto.inventory.PackagerExtensionItemHandler;
import thelm.packagedauto.menu.PackagerExtensionMenu;
import thelm.packagedauto.util.MiscHelper;

public class PackagerExtensionBlockEntity extends BaseBlockEntity implements ISettingsCloneable {

	public static final BlockEntityType<PackagerExtensionBlockEntity> TYPE_INSTANCE = (BlockEntityType<PackagerExtensionBlockEntity>)BlockEntityType.Builder.
			m_155273_(MiscHelper.INSTANCE.<BlockEntityType.BlockEntitySupplier<PackagerExtensionBlockEntity>>conditionalSupplier(
					()->ModList.get().isLoaded("ae2"),
					()->()->AEPackagerExtensionBlockEntity::new, ()->()->PackagerExtensionBlockEntity::new).get(),
					PackagerExtensionBlock.INSTANCE).
			m_58966_(null).setRegistryName("packagedauto:packager_extension");

	public static int energyCapacity = 5000;
	public static int energyReq = 500;
	public static int energyUsage = 100;
	public static int refreshInterval = 4;
	public static boolean drawMEEnergy = true;

	public boolean firstTick = true;
	public boolean isWorking = false;
	public int remainingProgress = 0;
	public PackagerBlockEntity packager;
	public IItemHandlerModifiable listStackItemHandler = new ItemStackHandler(1);
	public List<IPackagePattern> patternList = new ArrayList<>();
	public IPackagePattern currentPattern;
	public boolean lockPattern = false;
	public PackagerBlockEntity.Mode mode = PackagerBlockEntity.Mode.EXACT;
	public boolean disjoint = false;
	public boolean powered = false;

	public PackagerExtensionBlockEntity(BlockPos pos, BlockState state) {
		super(TYPE_INSTANCE, pos, state);
		setItemHandler(new PackagerExtensionItemHandler(this));
		setEnergyStorage(new EnergyStorage(this, energyCapacity));
	}

	@Override
	protected Component getDefaultName() {
		return new TranslatableComponent("block.packagedauto.packager_extension");
	}

	@Override
	public String getConfigTypeName() {
		return "block.packagedauto.packager";
	}

	@Override
	public void tick() {
		if(firstTick) {
			firstTick = false;
			updatePatternList();
			updatePowered();
		}
		if(!f_58857_.f_46443_) {
			if(isWorking) {
				tickProcess();
				if(remainingProgress <= 0 && isInputValid()) {
					finishProcess();
					if(!itemHandler.getStackInSlot(9).m_41619_()) {
						ejectItem();
					}
					if(!canStart()) {
						endProcess();
					}
					else {
						startProcess();
					}
				}
			}
			else if(f_58857_.m_46467_() % refreshInterval == 0) {
				if(canStart()) {
					startProcess();
					tickProcess();
					isWorking = true;
				}
			}
			chargeEnergy();
			if(f_58857_.m_46467_() % refreshInterval == 0) {
				if(!itemHandler.getStackInSlot(9).m_41619_()) {
					ejectItem();
				}
			}
		}
	}

	public boolean isInputValid() {
		if(currentPattern == null) {
			getPattern();
		}
		if(currentPattern == null) {
			return false;
		}
		List<ItemStack> input = itemHandler.getStacks().subList(0, 9).stream().filter(stack->!stack.m_41619_()).toList();
		if(input.isEmpty()) {
			return false;
		}
		if(!lockPattern && disjoint) {
			return MiscHelper.INSTANCE.removeExactSet(input, currentPattern.getInputs(), true);
		}
		List<Ingredient> matchers = Lists.transform(currentPattern.getInputs(), PackagerBlockEntity::getIngredient);
		int[] matches = RecipeMatcher.findMatches(input, matchers);
		if(matches == null) {
			return false;
		}
		for(int i = 0; i < matches.length; ++i) {
			if(input.get(i).m_41613_() < currentPattern.getInputs().get(matches[i]).m_41613_()) {
				return false;
			}
		}
		return true;
	}

	protected boolean canStart() {
		getPattern();
		if(currentPattern == null) {
			return false;
		}
		if(!isInputValid()) {
			return false;
		}
		ItemStack slotStack = itemHandler.getStackInSlot(9);
		ItemStack outputStack = currentPattern.getOutput();
		return slotStack.m_41619_() || ItemStack.m_150942_(slotStack, outputStack) && slotStack.m_41613_()+1 <= outputStack.m_41741_();
	}

	protected boolean canFinish() {
		return remainingProgress <= 0 && isInputValid();
	}

	protected void getPattern() {
		if(currentPattern != null && lockPattern) {
			return;
		}
		lockPattern = false;
		currentPattern = null;
		if(powered) {
			return;
		}
		List<ItemStack> input = itemHandler.getStacks().subList(0, 9).stream().filter(stack->!stack.m_41619_()).toList();
		if(input.isEmpty()) {
			return;
		}
		for(IPackagePattern pattern : patternList) {
			if(disjoint) {
				if(MiscHelper.INSTANCE.removeExactSet(input, pattern.getInputs(), true)) {
					currentPattern = pattern;
					return;
				}
			}
			else {
				List<Ingredient> matchers = Lists.transform(pattern.getInputs(), PackagerBlockEntity::getIngredient);
				int[] matches = RecipeMatcher.findMatches(input, matchers);
				if(matches != null) {
					currentPattern = pattern;
					return;
				}
			}
		}
	}

	public void updatePatternList() {
		packager = null;
		listStackItemHandler.setStackInSlot(0, ItemStack.f_41583_);
		patternList.clear();
		if(f_58857_ != null) {
			for(BlockPos posP : BlockPos.m_121940_(f_58858_.m_142082_(-1, -1, -1), f_58858_.m_142082_(1, 1, 1))) {
				if(f_58857_.m_7702_(posP) instanceof PackagerBlockEntity packager) {
					this.packager = packager;
					ItemStack listStack = packager.itemHandler.getStackInSlot(10);
					listStackItemHandler.setStackInSlot(0, listStack);
					patternList.addAll(packager.patternList);
					disjoint = switch(mode) {
					case EXACT -> false;
					case DISJOINT -> MiscHelper.INSTANCE.arePatternsDisjoint(patternList);
					case FIRST -> true;
					};
					break;
				}
			}
		}
	}

	protected void tickProcess() {
		int energy = energyStorage.extractEnergy(Math.min(energyUsage, remainingProgress), false);
		remainingProgress -= energy;
	}

	protected void finishProcess() {
		if(currentPattern == null) {
			getPattern();
		}
		if(currentPattern == null) {
			endProcess();
			return;
		}
		List<ItemStack> input = itemHandler.getStacks().subList(0, 9).stream().filter(stack->!stack.m_41619_()).toList();
		if(input.isEmpty()) {
			endProcess();
			return;
		}
		if(!lockPattern && disjoint) {
			if(!MiscHelper.INSTANCE.removeExactSet(input, currentPattern.getInputs(), true)) {
				endProcess();
				return;
			}
			if(itemHandler.getStackInSlot(9).m_41619_()) {
				itemHandler.setStackInSlot(9, currentPattern.getOutput());
			}
			else if(itemHandler.getStackInSlot(9).m_41720_() instanceof IPackageItem) {
				itemHandler.getStackInSlot(9).m_41769_(1);
			}
			else {
				endProcess();
				return;
			}
			MiscHelper.INSTANCE.removeExactSet(input, currentPattern.getInputs(), false);
		}
		else {
			List<Ingredient> matchers = Lists.transform(currentPattern.getInputs(), PackagerBlockEntity::getIngredient);
			int[] matches = RecipeMatcher.findMatches(input, matchers);
			if(matches == null) {
				endProcess();
				return;
			}
			if(itemHandler.getStackInSlot(9).m_41619_()) {
				itemHandler.setStackInSlot(9, currentPattern.getOutput());
			}
			else if(itemHandler.getStackInSlot(9).m_41720_() instanceof IPackageItem) {
				itemHandler.getStackInSlot(9).m_41769_(1);
			}
			else {
				endProcess();
				return;
			}
			for(int i = 0; i < matches.length; ++i) {
				input.get(i).m_41774_(currentPattern.getInputs().get(matches[i]).m_41613_());
			}
		}
		for(int i = 0; i < 9; ++i) {
			if(itemHandler.getStackInSlot(i).m_41619_()) {
				itemHandler.setStackInSlot(i, ItemStack.f_41583_);
			}
		}
	}

	protected void startProcess() {
		remainingProgress = energyReq;
		m_6596_();
	}

	public void endProcess() {
		remainingProgress = 0;
		isWorking = false;
		lockPattern = false;
		m_6596_();
	}

	protected void ejectItem() {
		for(Direction direction : Direction.values()) {
			if(f_58857_.m_7702_(f_58858_.m_142300_(direction)) instanceof UnpackagerBlockEntity unpackager) {
				ItemStack stack = itemHandler.getStackInSlot(9);
				if(!stack.m_41619_()) {
					ItemStack stackRem = ItemHandlerHelper.insertItem(unpackager.itemHandler, stack, false);
					itemHandler.setStackInSlot(9, stackRem);
				}
			}
		}
	}

	protected void chargeEnergy() {
		ItemStack energyStack = itemHandler.getStackInSlot(10);
		if(energyStack.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
			int energyRequest = Math.min(energyStorage.getMaxReceive(), energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored());
			energyStorage.receiveEnergy(energyStack.getCapability(CapabilityEnergy.ENERGY).resolve().get().extractEnergy(energyRequest, false), false);
			if(energyStack.m_41613_() <= 0) {
				itemHandler.setStackInSlot(10, ItemStack.f_41583_);
			}
		}
	}

	public void updatePowered() {
		if(f_58857_.m_46755_(f_58858_) > 0 != powered) {
			powered = !powered;
			m_6596_();
		}
	}

	@Override
	public int getComparatorSignal() {
		if(isWorking) {
			return 1;
		}
		if(!itemHandler.getStackInSlot(9).m_41619_()) {
			return 15;
		}
		return 0;
	}

	public boolean canPushPattern() {
		return !isWorking && itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::m_41619_);
	}

	@Override
	public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
		mode = PackagerBlockEntity.Mode.values()[nbt.m_128445_("Mode")];
		return ISettingsCloneable.Result.success();
	}

	@Override
	public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
		nbt.m_128344_("Mode", (byte)mode.ordinal());
		ItemStack listStack = listStackItemHandler.getStackInSlot(0);
		if(listStack.m_41720_() instanceof IPackageRecipeListItem recipeListItem) {
			List<IPackageRecipeInfo> recipeList = recipeListItem.getRecipeList(listStack).getRecipeList();
			if(!recipeList.isEmpty()) {
				nbt.m_128365_("Recipes", MiscHelper.INSTANCE.saveRecipeList(new ListTag(), recipeList));
			}
		}
		return ISettingsCloneable.Result.success();
	}

	@Override
	public void m_142466_(CompoundTag nbt) {
		mode = PackagerBlockEntity.Mode.values()[nbt.m_128445_("Mode")];
		super.m_142466_(nbt);
		updatePatternList();
		isWorking = nbt.m_128471_("Working");
		remainingProgress = nbt.m_128451_("Progress");
		powered = nbt.m_128471_("Powered");
		lockPattern = false;
		currentPattern = null;
		if(nbt.m_128441_("Pattern")) {
			CompoundTag tag = nbt.m_128469_("Pattern");
			IPackageRecipeInfo recipe = MiscHelper.INSTANCE.loadRecipe(tag);
			if(recipe != null) {
				List<IPackagePattern> patterns = recipe.getPatterns();
				byte index = tag.m_128445_("Index");
				if(index >= 0 && index < patterns.size()) {
					currentPattern = patterns.get(index);
					lockPattern = true;
				}
			}
		}
	}

	@Override
	public void m_183515_(CompoundTag nbt) {
		super.m_183515_(nbt);
		nbt.m_128344_("Mode", (byte)mode.ordinal());
		nbt.m_128379_("Working", isWorking);
		nbt.m_128405_("Progress", remainingProgress);
		nbt.m_128379_("Powered", powered);
		if(lockPattern) {
			CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), currentPattern.getRecipeInfo());
			tag.m_128344_("Index", (byte)currentPattern.getIndex());
			nbt.m_128365_("Pattern", tag);
		}
	}

	@Override
	public void loadSync(CompoundTag nbt) {
		super.loadSync(nbt);
	}

	@Override
	public CompoundTag saveSync(CompoundTag nbt) {
		super.saveSync(nbt);
		return nbt;
	}

	public void changePackagingMode() {
		mode = PackagerBlockEntity.Mode.values()[((mode.ordinal()+1) % 3)];
		updatePatternList();
		m_6596_();
	}

	@Override
	public void m_6596_() {
		if(isWorking && !isInputValid()) {
			endProcess();
		}
		super.m_6596_();
	}

	public int getScaledEnergy(int scale) {
		if(energyStorage.getMaxEnergyStored() <= 0) {
			return 0;
		}
		return Math.min(scale * energyStorage.getEnergyStored() / energyStorage.getMaxEnergyStored(), scale);
	}

	public int getScaledProgress(int scale) {
		if(remainingProgress <= 0 || energyReq <= 0) {
			return 0;
		}
		return scale * (energyReq-remainingProgress) / energyReq;
	}

	@Override
	public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
		sync(false);
		return new PackagerExtensionMenu(windowId, inventory, this);
	}
}
