package thelm.packagedauto.client.screen;

import java.util.List;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.CycleRecipeTypePacket;
import thelm.packagedauto.network.packet.LoadRecipeListPacket;
import thelm.packagedauto.network.packet.SaveRecipeListPacket;
import thelm.packagedauto.network.packet.SetPatternIndexPacket;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class EncoderScreen extends BaseScreen<EncoderMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/encoder.png");

	public EncoderScreen(EncoderMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
		f_97726_ = 258;
		f_97727_ = 314;
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void m_7856_() {
		m_169413_();
		super.m_7856_();
		int patternSlots = menu.blockEntity.patternItemHandlers.length;
		for(int i = 0; i < patternSlots; ++i) {
			m_142416_(new ButtonPatternSlot(i, f_97735_+30+(i%10)*18, f_97736_+(patternSlots > 10 ? 16 : 25)+(i/10)*18));
		}
		m_142416_(new ButtonRecipeType(true, f_97735_+189, f_97736_+74));
		m_142416_(new ButtonRecipeType(false, f_97735_+225, f_97736_+74));
		m_142416_(new ButtonSavePatterns(f_97735_+215, f_97736_+16));
		m_142416_(new ButtonLoadPatterns(f_97735_+215, f_97736_+34));
		m_142416_(new ButtonClearPatterns(f_97735_+171, f_97736_+56));
	}

	@Override
	protected void renderBgAdditional(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
		IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
		for(int i = 0; i < 9; ++i) {
			for(int j = 0; j < 9; ++j) {
				Vec3i color = recipeType.getSlotColor(i*9+j);
				RenderSystem.m_157429_(color.m_123341_()/255F, color.m_123342_()/255F, color.m_123343_()/255F, 1F);
				m_93133_(poseStack, f_97735_+8+j*18, f_97736_+57+i*18, 258, 0, 16, 16, 512, 512);
			}
		}
		for(int i = 0; i < 3; ++i) {
			for(int j = 0; j < 3; ++j) {
				int slotIndex = 81+(i*3+j == 4 ? 0 : i*3+j < 4 ? i*3+j+1 : i*3+j);
				Vec3i color = recipeType.getSlotColor(slotIndex);
				RenderSystem.m_157429_(color.m_123341_()/255F, color.m_123342_()/255F, color.m_123343_()/255F, 1F);
				m_93133_(poseStack, f_97735_+198+j*18, f_97736_+111+i*18, 258, 0, 16, 16, 512, 512);
			}
		}
		RenderSystem.m_157429_(1F, 1F, 1F, 1F);
	}

	@Override
	protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		f_96547_.m_92883_(poseStack, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040);
		f_96547_.m_92883_(poseStack, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040);
		String str = menu.patternItemHandler.recipeType.getShortDisplayName().getString();
		f_96547_.m_92883_(poseStack, str, 212 - f_96547_.m_92895_(str)/2, 64, 0x404040);
		super.m_7027_(poseStack, mouseX, mouseY);
		IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
		if(recipeType != null) {
			Object rep = recipeType.getRepresentation();
			if(rep instanceof TextureAtlasSprite sprite) {
				RenderSystem.m_157429_(1F, 1F, 1F, 1F);
				RenderSystem.m_157456_(0, InventoryMenu.f_39692_);
				m_93200_(poseStack, 204, 75, 0, 16, 16, sprite);
			}
			if(rep instanceof ItemStack stack) {
				RenderSystem.m_157429_(1F, 1F, 1F, 1F);
				f_96541_.m_91291_().m_115123_(stack, 204, 75);
			}
		}
		for(GuiEventListener child : m_6702_()) {
			if(child.m_5953_(mouseX, mouseY) && child instanceof AbstractWidget button) {
				button.m_7428_(poseStack, mouseX-f_97735_, mouseY-f_97736_);
				break;
			}
		}
	}

	@Override
	public int getItemAmountSpecificationLimit(Slot slot) {
		int stackLimit = slot.m_7993_().m_41741_();
		return slot.f_40219_ > 81 ? Math.max(stackLimit, 999) : stackLimit;
	}

	class ButtonPatternSlot extends AbstractWidget {

		int id;

		ButtonPatternSlot(int id, int x, int y) {
			super(x, y, 18, 18, TextComponent.f_131282_);
			this.id = id;
		}

		@Override
		protected int m_7202_(boolean mouseOver) {
			if(menu.blockEntity.patternIndex == id) {
				return 2;
			}
			return super.m_7202_(mouseOver);
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			for(int i = 81; i < 90; ++i) {
				ItemStack stack = menu.blockEntity.patternItemHandlers[id].getStackInSlot(i);
				if(!stack.m_41619_()) {
					RenderSystem.m_157429_(1F, 1F, 1F, 1F);
					minecraft.m_91291_().m_115123_(stack, f_93620_+1, f_93621_+1);
					break;
				}
			}
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			m_96602_(poseStack, new TranslatableComponent("block.packagedauto.encoder.pattern_slot", String.format("%02d", id)), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(new SetPatternIndexPacket(id));
			menu.blockEntity.setPatternIndex(id);
			menu.setupSlots();
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}

	class ButtonRecipeType extends AbstractWidget {

		final boolean prev;

		ButtonRecipeType(boolean prev, int x, int y) {
			super(x, y, 10, 18, TextComponent.f_131282_);
			this.prev = prev;
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.m_157429_(1F, 1F, 1F, 1F);
			RenderSystem.m_157456_(0, BACKGROUND);
			m_93133_(poseStack, f_93620_+1, f_93621_+1, prev ? 258 : 266, 48, 8, 16, 512, 512);
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			m_96602_(poseStack, new TranslatableComponent("block.packagedauto.encoder.recipe_type."+(prev ? "prev" : "next")), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(new CycleRecipeTypePacket(prev));
			menu.patternItemHandler.cycleRecipeType(prev);
			menu.setupSlots();
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}

	class ButtonSavePatterns extends AbstractWidget {

		ButtonSavePatterns(int x, int y) {
			super(x, y, 36, 18, TextComponent.f_131282_);
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.m_157429_(1F, 1F, 1F, 1F);
			RenderSystem.m_157456_(0, BACKGROUND);
			m_93133_(poseStack, f_93620_+1, f_93621_+1, 258, 16, 34, 16, 512, 512);
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			Component line0 = new TranslatableComponent("block.packagedauto.encoder.save");
			Component line1 = new TranslatableComponent("block.packagedauto.encoder.save.single").m_130940_(ChatFormatting.GRAY);
			m_96597_(poseStack, List.of(line0, line1), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			boolean single = m_96638_();
			PacketHandler.INSTANCE.sendToServer(new SaveRecipeListPacket(single));
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}

	class ButtonLoadPatterns extends AbstractWidget {

		ButtonLoadPatterns(int x, int y) {
			super(x, y, 36, 18, TextComponent.f_131282_);
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.m_157429_(1F, 1F, 1F, 1F);
			RenderSystem.m_157456_(0, BACKGROUND);
			m_93133_(poseStack, f_93620_+1, f_93621_+1, 258, 32, 34, 16, 512, 512);
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			Component line0 = new TranslatableComponent("block.packagedauto.encoder.load");
			Component line1 = new TranslatableComponent("block.packagedauto.encoder.load.single").m_130940_(ChatFormatting.GRAY);
			m_96597_(poseStack, List.of(line0, line1), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			boolean single = m_96638_();
			PacketHandler.INSTANCE.sendToServer(new LoadRecipeListPacket(single, false));
			menu.blockEntity.loadRecipeList(single, false);
			menu.setupSlots();
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}

	class ButtonClearPatterns extends AbstractWidget {

		ButtonClearPatterns(int x, int y) {
			super(x, y, 7, 7, TextComponent.f_131282_);
		}

		@Override
		public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			Component line0 = new TranslatableComponent("block.packagedauto.encoder.clear");
			Component line1 = new TranslatableComponent("block.packagedauto.encoder.clear.all").m_130940_(ChatFormatting.GRAY);
			m_96597_(poseStack, List.of(line0, line1), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			boolean single = !m_96638_();
			PacketHandler.INSTANCE.sendToServer(new LoadRecipeListPacket(single, true));
			menu.blockEntity.loadRecipeList(single, true);
			menu.setupSlots();
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}
}
