package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.menu.PackagerExtensionMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.ChangePackagingPacket;

public class PackagerExtensionScreen extends BaseScreen<PackagerExtensionMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/packager_extension.png");

	public PackagerExtensionScreen(PackagerExtensionMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void m_7856_() {
		m_169413_();
		super.m_7856_();
		m_142416_(new ButtonChangePackaging(f_97735_+98, f_97736_+16));
	}

	@Override
	protected void renderBgAdditional(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
		m_93228_(poseStack, f_97735_+102, f_97736_+53, 176, 0, menu.blockEntity.getScaledProgress(22), 16);
		int scaledEnergy = menu.blockEntity.getScaledEnergy(40);
		m_93228_(poseStack, f_97735_+10, f_97736_+10+40-scaledEnergy, 176, 16+40-scaledEnergy, 12, scaledEnergy);
	}

	@Override
	protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		f_96547_.m_92883_(poseStack, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040);
		f_96547_.m_92883_(poseStack, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040);
		if(mouseX-f_97735_ >= 10 && mouseY-f_97736_ >= 10 && mouseX-f_97735_ <= 21 && mouseY-f_97736_ <= 49) {
			m_96602_(poseStack, new TextComponent(menu.blockEntity.getEnergyStorage().getEnergyStored()+" / "+menu.blockEntity.getEnergyStorage().getMaxEnergyStored()+" FE"), mouseX-f_97735_, mouseY-f_97736_);
		}
		for(GuiEventListener child : m_6702_()) {
			if(child.m_5953_(mouseX, mouseY) && child instanceof AbstractWidget button) {
				button.m_7428_(poseStack, mouseX-f_97735_, mouseY-f_97736_);
				break;
			}
		}
		super.m_7027_(poseStack, mouseX, mouseY);
	}

	class ButtonChangePackaging extends AbstractWidget {

		public ButtonChangePackaging(int x, int y) {
			super(x, y, 16, 18, TextComponent.f_131282_);
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.m_157429_(1F, 1F, 1F, 1F);
			RenderSystem.m_157456_(0, BACKGROUND);
			m_93228_(poseStack, f_93620_+1, f_93621_+2, 176, 56+14*menu.blockEntity.mode.ordinal(), 14, 14);
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			m_96602_(poseStack, menu.blockEntity.mode.getTooltip(), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(ChangePackagingPacket.INSTANCE);
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}
}
