package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.block.entity.PackagingProviderBlockEntity;
import thelm.packagedauto.menu.PackagingProviderMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.ChangeBlockingPacket;
import thelm.packagedauto.network.packet.ChangeProvidingPacket;

public class PackagingProviderScreen extends BaseScreen<PackagingProviderMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/packaging_provider.png");

	public PackagingProviderScreen(PackagingProviderMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void m_7856_() {
		m_169413_();
		super.m_7856_();
		m_142416_(new ButtonChangeBlocking(f_97735_+62, f_97736_+34));
		m_142416_(new ButtonChangeProvideDirect(f_97735_+98, f_97736_+34));
		m_142416_(new ButtonChangeProvidePackaging(f_97735_+116, f_97736_+34));
		m_142416_(new ButtonChangeProvideUnpackaging(f_97735_+134, f_97736_+34));
	}

	@Override
	protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		f_96547_.m_92883_(poseStack, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040);
		f_96547_.m_92883_(poseStack, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040);
		for(GuiEventListener child : m_6702_()) {
			if(child.m_5953_(mouseX, mouseY) && child instanceof AbstractWidget button) {
				button.m_7428_(poseStack, mouseX-f_97735_, mouseY-f_97736_);
				break;
			}
		}
		super.m_7027_(poseStack, mouseX, mouseY);
	}

	class ButtonChangeBlocking extends AbstractWidget {

		public ButtonChangeBlocking(int x, int y) {
			super(x, y, 16, 18, TextComponent.f_131282_);
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.m_157429_(1F, 1F, 1F, 1F);
			RenderSystem.m_157456_(0, BACKGROUND);
			m_93228_(poseStack, f_93620_+1, f_93621_+2, 176, menu.blockEntity.blocking ? 14 : 0, 14, 14);
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			m_96602_(poseStack, new TranslatableComponent("block.packagedauto.unpackager.blocking."+menu.blockEntity.blocking), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(ChangeBlockingPacket.INSTANCE);
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}

	class ButtonChangeProvideDirect extends AbstractWidget {

		public ButtonChangeProvideDirect(int x, int y) {
			super(x, y, 16, 18, TextComponent.f_131282_);
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.m_157429_(1F, 1F, 1F, 1F);
			RenderSystem.m_157456_(0, BACKGROUND);
			m_93228_(poseStack, f_93620_+1, f_93621_+2, 176, menu.blockEntity.provideDirect ? 42 : 28, 14, 14);
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			m_96602_(poseStack, new TranslatableComponent("block.packagedauto.packaging_provider.direct."+menu.blockEntity.provideDirect), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(new ChangeProvidingPacket(PackagingProviderBlockEntity.Type.DIRECT));
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}

	class ButtonChangeProvidePackaging extends AbstractWidget {

		public ButtonChangeProvidePackaging(int x, int y) {
			super(x, y, 16, 18, TextComponent.f_131282_);
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.m_157429_(1F, 1F, 1F, 1F);
			RenderSystem.m_157456_(0, BACKGROUND);
			m_93228_(poseStack, f_93620_+1, f_93621_+2, 176, menu.blockEntity.providePackaging ? 70 : 56, 14, 14);
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			m_96602_(poseStack, new TranslatableComponent("block.packagedauto.packaging_provider.packaging."+menu.blockEntity.providePackaging), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(new ChangeProvidingPacket(PackagingProviderBlockEntity.Type.PACKAGING));
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}

	class ButtonChangeProvideUnpackaging extends AbstractWidget {

		public ButtonChangeProvideUnpackaging(int x, int y) {
			super(x, y, 16, 18, TextComponent.f_131282_);
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.m_157429_(1F, 1F, 1F, 1F);
			RenderSystem.m_157456_(0, BACKGROUND);
			m_93228_(poseStack, f_93620_+1, f_93621_+2, 176, menu.blockEntity.provideUnpackaging ? 98 : 84, 14, 14);
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			m_96602_(poseStack, new TranslatableComponent("block.packagedauto.packaging_provider.unpackaging."+menu.blockEntity.provideUnpackaging), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(new ChangeProvidingPacket(PackagingProviderBlockEntity.Type.UNPACKAGING));
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}
}
