package thelm.packagedauto.integration.appeng.blockentity;

import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.block.CraftingProxyBlock;
import thelm.packagedauto.block.entity.CraftingProxyBlockEntity;

public class AECraftingProxyBlockEntity extends CraftingProxyBlockEntity implements IInWorldGridNodeHost, IGridNodeListener<AECraftingProxyBlockEntity>, IActionHost {

	public boolean firstTick = true;
	public IActionSource source;
	public IManagedGridNode gridNode;

	public AECraftingProxyBlockEntity(BlockPos pos, BlockState state) {
		super(pos, state);
		source = IActionSource.ofMachine(this);
	}

	@Override
	public void tick() {
		if(firstTick) {
			firstTick = false;
			getMainNode().create(f_58857_, f_58858_);
		}
		super.tick();
	}

	@Override
	public void m_7651_() {
		super.m_7651_();
		if(gridNode != null) {
			gridNode.destroy();
		}
	}

	@Override
	public void onChunkUnloaded() {
		super.onChunkUnloaded();
		if(gridNode != null) {
			gridNode.destroy();
		}
	}

	@Override
	public IGridNode getGridNode(Direction dir) {
		return getActionableNode();
	}

	@Override
	public AECableType getCableConnectionType(Direction dir) {
		return AECableType.SMART;
	}

	@Override
	public void onSecurityBreak(AECraftingProxyBlockEntity nodeOwner, IGridNode node) {
		f_58857_.m_46961_(f_58858_, true);
	}

	@Override
	public void onSaveChanges(AECraftingProxyBlockEntity nodeOwner, IGridNode node) {
		m_6596_();
	}

	public IManagedGridNode getMainNode() {
		if(gridNode == null) {
			gridNode = GridHelper.createManagedNode(this, this);
			gridNode.setTagName("Node");
			gridNode.setVisualRepresentation(CraftingProxyBlock.INSTANCE);
			gridNode.setGridColor(AEColor.TRANSPARENT);
			gridNode.setIdlePowerUsage(1);
			gridNode.setInWorldNode(true);
			if(ownerUUID != null && f_58857_ instanceof ServerLevel) {
				gridNode.setOwningPlayerId(IPlayerRegistry.getMapping(f_58857_).getPlayerId(ownerUUID));
			}
		}
		return gridNode;
	}

	@Override
	public IGridNode getActionableNode() {
		return getMainNode().getNode();
	}

	@Override
	public void m_142466_(CompoundTag nbt) {
		super.m_142466_(nbt);
		if(nbt.m_128441_("Node")) {
			getMainNode().loadFromNBT(nbt);
		}
	}

	@Override
	public void m_183515_(CompoundTag nbt) {
		super.m_183515_(nbt);
		if(gridNode != null) {
			gridNode.saveToNBT(nbt);
		}
	}
}
