package thelm.packagedauto.inventory;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandlerModifiable;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.PackagerExtensionBlockEntity;
import thelm.packagedauto.util.MiscHelper;

public class PackagerItemHandler extends BaseItemHandler<PackagerBlockEntity> {

	public PackagerItemHandler(PackagerBlockEntity blockEntity) {
		super(blockEntity, 12);
	}

	@Override
	protected void onContentsChanged(int slot) {
		if(slot < 9 && !blockEntity.m_58904_().f_46443_) {
			if(blockEntity.isWorking && !getStackInSlot(slot).m_41619_() && !blockEntity.isInputValid()) {
				blockEntity.endProcess();
			}
		}
		if(slot == 10) {
			updatePatternList();
		}
		super.onContentsChanged(slot);
	}

	@Override
	public int getSlotLimit(int slot) {
		if(slot == 10) {
			return 1;
		}
		return super.getSlotLimit(slot);
	}

	@Override
	public boolean isItemValid(int slot, ItemStack stack) {
		return switch(slot) {
		case 9 -> false;
		case 10 -> stack.m_41720_() instanceof IPackageRecipeListItem || stack.m_41720_() instanceof IPackageItem;
		case 11 -> stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
		default -> blockEntity.isWorking ? !getStackInSlot(slot).m_41619_() : true;
		};
	}

	@Override
	public IItemHandlerModifiable getWrapperForDirection(Direction side) {
		return wrapperMap.computeIfAbsent(side, s->new PackagerItemHandlerWrapper(this, s));
	}

	@Override
	public int m_6413_(int id) {
		return switch(id) {
		case 0 -> blockEntity.remainingProgress;
		case 1 -> blockEntity.isWorking ? 1 : 0;
		case 2 -> blockEntity.mode.ordinal();
		case 3 -> blockEntity.getEnergyStorage().getEnergyStored();
		default -> 0;
		};
	}

	@Override
	public void m_8050_(int id, int value) {
		switch(id) {
		case 0 -> blockEntity.remainingProgress = value;
		case 1 -> blockEntity.isWorking = value != 0;
		case 2 -> blockEntity.mode = PackagerBlockEntity.Mode.values()[value];
		case 3 -> blockEntity.getEnergyStorage().setEnergyStored(value);
		}
	}

	@Override
	public int m_6499_() {
		return 4;
	}

	@Override
	public void load(CompoundTag nbt) {
		super.load(nbt);
		updatePatternList();
	}

	public void updatePatternList() {
		blockEntity.patternList.clear();
		ItemStack listStack = getStackInSlot(10);
		if(listStack.m_41720_() instanceof IPackageRecipeListItem listItem) {
			listItem.getRecipeList(listStack).getRecipeList().stream().
			filter(IPackageRecipeInfo::isValid).forEach(recipe->{
				recipe.getPatterns().forEach(blockEntity.patternList::add);
				recipe.getExtraPatterns().forEach(blockEntity.patternList::add);
			});
		}
		else if(listStack.m_41720_() instanceof IPackageItem packageItem) {
			IPackageRecipeInfo recipe = packageItem.getRecipeInfo(listStack);
			int index = packageItem.getIndex(listStack);
			if(recipe != null && recipe.isValid() && recipe.validPatternIndex(index)) {
				blockEntity.patternList.add(recipe.getPatterns().get(index));
			}
		}
		blockEntity.disjoint = switch(blockEntity.mode) {
		case EXACT -> false;
		case DISJOINT -> MiscHelper.INSTANCE.arePatternsDisjoint(blockEntity.patternList);
		case FIRST -> true;
		};
		if(blockEntity.m_58904_() != null && !blockEntity.m_58904_().f_46443_) {
			blockEntity.postPatternChange();
		}
		if(blockEntity.m_58904_() != null) {
			BlockPos.m_121990_(blockEntity.m_58899_().m_142082_(-1, -1, -1), blockEntity.m_58899_().m_142082_(1, 1, 1)).
			map(blockEntity.m_58904_()::m_7702_).filter(t->t instanceof PackagerExtensionBlockEntity).
			map(t->(PackagerExtensionBlockEntity)t).forEach(t->t.updatePatternList());
		}
	}
}
