package thelm.packagedauto.item;

import java.util.List;

import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.ISettingsClonerItem;
import thelm.packagedauto.api.SettingsClonerData;

public class SettingsClonerItem extends Item implements ISettingsClonerItem {

	public static final SettingsClonerItem INSTANCE = new SettingsClonerItem();

	protected SettingsClonerItem() {
		super(new Item.Properties().m_41487_(1).m_41491_(PackagedAuto.CREATIVE_TAB));
		setRegistryName("packagedauto:settings_cloner");
	}

	@Override
	public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
		Level level = context.m_43725_();
		Player player = context.m_43723_();
		BlockPos pos = context.m_8083_();
		BlockEntity blockEntity = level.m_7702_(pos);
		if(blockEntity instanceof ISettingsCloneable settable) {
			String configName = settable.getConfigTypeName();
			if(player.m_6144_()) {
				if(!level.f_46443_) {
					CompoundTag dataTag = new CompoundTag();
					ISettingsCloneable.Result result = settable.saveConfig(dataTag, player);
					if(result.type() != ISettingsCloneable.ResultType.FAIL) {
						CompoundTag tag = stack.m_41784_();
						tag.m_128359_("Type", configName);
						tag.m_128365_("Data", dataTag);
						tag.m_128359_("Dimension", level.m_46472_().m_135782_().toString());
						tag.m_128385_("Position", new int[] {pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
						player.m_6352_(new TranslatableComponent("item.packagedauto.settings_cloner.saved"), Util.f_137441_);
					}
					else {
						player.m_6352_(new TranslatableComponent("item.packagedauto.settings_cloner.not_saved", result.message()).m_130940_(ChatFormatting.RED), Util.f_137441_);
					}
				}
				return InteractionResult.SUCCESS;
			}
			SettingsClonerData data = getData(stack);
			if(data != null) {
				if(!level.f_46443_) {
					if(configName.equals(data.type())) {
						ISettingsCloneable.Result result = settable.loadConfig(data.data(), player);
						switch(result.type()) {
						case SUCCESS -> player.m_6352_(new TranslatableComponent("item.packagedauto.settings_cloner.loaded"), Util.f_137441_);
						case PARTIAL -> player.m_6352_(new TranslatableComponent("item.packagedauto.settings_cloner.partial_loaded", result.message()), Util.f_137441_);
						case FAIL -> player.m_6352_(new TranslatableComponent("item.packagedauto.settings_cloner.not_loaded", result.message()).m_130940_(ChatFormatting.RED), Util.f_137441_);
						}
					}
					else {
						Component errorMessage = new TranslatableComponent("item.packagedauto.settings_cloner.incompatible");
						player.m_6352_(new TranslatableComponent("item.packagedauto.settings_cloner.not_loaded", errorMessage).m_130940_(ChatFormatting.RED), Util.f_137441_);
					}
				}
				return InteractionResult.SUCCESS;
			}
		}
		return super.onItemUseFirst(stack, context);
	}

	@Override
	public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
		if(!level.f_46443_ && player.m_6144_() && hasData(player.m_21120_(hand))) {
			ItemStack stack = player.m_21120_(hand).m_41777_();
			CompoundTag nbt = stack.m_41783_();
			nbt.m_128473_("Type");
			nbt.m_128473_("Data");
			nbt.m_128473_("Dimension");
			nbt.m_128473_("Position");
			if(nbt.m_128456_()) {
				stack.m_41751_(null);
			}
			player.m_6352_(new TranslatableComponent("item.packagedauto.settings_cloner.cleared"), Util.f_137441_);
			return InteractionResultHolder.m_19090_(stack);
		}
		return super.m_7203_(level, player, hand);
	}

	@Override
	public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
		SettingsClonerData data = getData(stack);
		if(data != null) {
			Component typeComponent = new TranslatableComponent(data.type());
			tooltip.add(new TranslatableComponent("item.packagedauto.settings_cloner.contents", typeComponent));
			Component dimComponent = new TextComponent(data.dimension().m_135782_().toString());
			tooltip.add(new TranslatableComponent("misc.packagedauto.dimension", dimComponent));
			Component posComponent = ComponentUtils.m_130748_(new TranslatableComponent("chat.coordinates", data.x(), data.y(), data.z()));
			tooltip.add(new TranslatableComponent("misc.packagedauto.position", posComponent));
		}
		super.m_7373_(stack, level, tooltip, isAdvanced);
	}

	@Override
	public SettingsClonerData getData(ItemStack stack) {
		if(hasData(stack)) {
			CompoundTag nbt = stack.m_41783_();
			String type = nbt.m_128461_("Type");
			CompoundTag data = nbt.m_128469_("Data");
			ResourceKey<Level> dimension = ResourceKey.m_135785_(Registry.f_122819_, new ResourceLocation(nbt.m_128461_("Dimension")));
			int[] posArray = nbt.m_128465_("Position");
			BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
			return new SettingsClonerData(type, data, dimension, blockPos);
		}
		return null;
	}

	public boolean hasData(ItemStack stack) {
		CompoundTag nbt = stack.m_41783_();
		return nbt != null && nbt.m_128441_("Type") && nbt.m_128441_("Data") && nbt.m_128441_("Dimension") && nbt.m_128441_("Position");
	}
}
