package thelm.packagedauto.item;

import java.util.List;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.util.ApiImpl;
import thelm.packagedauto.volume.UnknownStackWrapper;

public class VolumePackageItem extends Item implements IVolumePackageItem {

	public static final VolumePackageItem INSTANCE = new VolumePackageItem();

	protected VolumePackageItem() {
		super(new Item.Properties());
		setRegistryName("packagedauto:volume_package");
	}

	public static ItemStack makeVolumePackage(IVolumeStackWrapper volumeStack) {
		if(volumeStack.isEmpty()) {
			return ItemStack.f_41583_;
		}
		IVolumeType type = volumeStack.getVolumeType();
		ItemStack stack = new ItemStack(INSTANCE);
		CompoundTag nbt = new CompoundTag();
		nbt.m_128359_("Type", type.getName().toString());
		stack.m_41751_(nbt);
		type.setStack(stack, volumeStack);
		return stack;
	}

	public static ItemStack tryMakeVolumePackage(Object volumeStack) {
		if(volumeStack == null) {
			return ItemStack.f_41583_;
		}
		IVolumeType type = ApiImpl.INSTANCE.getVolumeType(volumeStack.getClass());
		if(type == null) {
			return ItemStack.f_41583_;
		}
		return type.wrapStack(volumeStack).map(s->makeVolumePackage(s)).orElse(ItemStack.f_41583_);
	}

	@Override
	public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
		IVolumeStackWrapper volumeStack = getVolumeStack(stack);
		if(!volumeStack.isEmpty()) {
			tooltip.add(volumeStack.getVolumeType().getDisplayName().m_130946_(": ").
					m_7220_(volumeStack.getDisplayName()).m_130946_(" ").
					m_7220_(volumeStack.getAmountDesc()));
		}
		super.m_7373_(stack, level, tooltip, isAdvanced);
	}

	@Override
	public IVolumeType getVolumeType(ItemStack stack) {
		CompoundTag nbt = stack.m_41783_();
		if(nbt == null || !nbt.m_128441_("Type")) {
			return null;
		}
		return ApiImpl.INSTANCE.getVolumeType(new ResourceLocation(nbt.m_128461_("Type")));
	}

	@Override
	public IVolumeStackWrapper getVolumeStack(ItemStack stack) {
		IVolumeType type = getVolumeType(stack);
		if(type != null) {
			return type.getStackContained(stack).orElse(type.getEmptyStackInstance());
		}
		return UnknownStackWrapper.INSTANCE;
	}

	@Override
	public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
		return new CapabilityProvider(stack);
	}

	static class CapabilityProvider implements ICapabilityProvider {

		private ItemStack container;

		public CapabilityProvider(ItemStack container) {
			this.container = container;
		}

		@Override
		public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
			if(container.m_41720_() instanceof IVolumePackageItem volumePackage) {
				IVolumeType type = volumePackage.getVolumeType(container);
				if(type != null) {
					return type.getItemCapability().orEmpty(capability, LazyOptional.of(()->type.makeItemCapability(container)));
				}
			}
			return LazyOptional.empty();
		}
	}
}
