package thelm.packagedauto.network.packet;

import java.util.function.Supplier;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import thelm.packagedauto.block.entity.PackagingProviderBlockEntity;
import thelm.packagedauto.menu.PackagingProviderMenu;

public record ChangeProvidingPacket(PackagingProviderBlockEntity.Type type) {

	public void encode(FriendlyByteBuf buf) {
		buf.m_130068_(type);
	}

	public static ChangeProvidingPacket decode(FriendlyByteBuf buf) {
		return new ChangeProvidingPacket(buf.m_130066_(PackagingProviderBlockEntity.Type.class));
	}

	public void handle(Supplier<NetworkEvent.Context> ctx) {
		ServerPlayer player = ctx.get().getSender();
		ctx.get().enqueueWork(()->{
			if(player.f_36096_ instanceof PackagingProviderMenu menu) {
				menu.blockEntity.changeProvideType(type);
			}
		});
		ctx.get().setPacketHandled(true);
	}
}
