/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.api;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public interface ISettingsCloneable {
    public String getConfigTypeName();

    public Result saveConfig(NBTTagCompound var1, EntityPlayer var2);

    public Result loadConfig(NBTTagCompound var1, EntityPlayer var2);

    public static enum ResultType {
        SUCCESS,
        PARTIAL,
        FAIL;

    }

    public static class Result {
        private static final ITextComponent EMPTY = new TextComponentString("");
        public final ResultType type;
        public final ITextComponent message;

        public Result(ResultType type, ITextComponent message) {
            this.type = type;
            this.message = message;
        }

        public static Result success() {
            return new Result(ResultType.SUCCESS, EMPTY);
        }

        public static Result partial(ITextComponent message) {
            return new Result(ResultType.PARTIAL, message);
        }

        public static Result fail(ITextComponent message) {
            return new Result(ResultType.FAIL, message);
        }
    }
}

