/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntRBTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.RecipeTypeRegistry;

public class MiscUtil {
    private static final Cache<NBTTagCompound, IRecipeInfo> RECIPE_CACHE = CacheBuilder.newBuilder().maximumSize(500L).build();
    private static final Logger LOGGER = LogManager.getLogger();

    private MiscUtil() {
    }

    public static List<ItemStack> condenseStacks(IInventory inventory) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(inventory.func_70302_i_());
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            stacks.add(inventory.func_70301_a(i));
        }
        return MiscUtil.condenseStacks(stacks);
    }

    public static List<ItemStack> condenseStacks(IItemHandler itemHandler) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(itemHandler.getSlots());
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            stacks.add(itemHandler.getStackInSlot(i));
        }
        return MiscUtil.condenseStacks(stacks);
    }

    public static List<ItemStack> condenseStacks(ItemStack ... stacks) {
        return MiscUtil.condenseStacks(Arrays.asList(stacks));
    }

    public static List<ItemStack> condenseStacks(Stream<ItemStack> stacks) {
        return MiscUtil.condenseStacks(stacks.collect(Collectors.toList()));
    }

    public static List<ItemStack> condenseStacks(Iterable<ItemStack> stacks) {
        return MiscUtil.condenseStacks(stacks instanceof List ? (List)stacks : Lists.newArrayList(stacks));
    }

    public static List<ItemStack> condenseStacks(List<ItemStack> stacks) {
        return MiscUtil.condenseStacks(stacks, false);
    }

    public static List<ItemStack> condenseStacks(List<ItemStack> stacks, boolean ignoreStackSize) {
        Object2IntRBTreeMap map = new Object2IntRBTreeMap(Comparator.comparing(triple -> Triple.of((Object)((Item)triple.getLeft()).getRegistryName(), (Object)triple.getMiddle(), (Object)("" + triple.getRight()))));
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            Triple triple2 = Triple.of((Object)stack.func_77973_b(), (Object)stack.func_77960_j(), (Object)stack.func_77978_p());
            if (!map.containsKey((Object)triple2)) {
                map.put((Object)triple2, 0);
            }
            map.addTo((Object)triple2, stack.func_190916_E());
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            int limit;
            ItemStack toAdd;
            int count;
            Triple triple3 = (Triple)entry.getKey();
            Item item = (Item)triple3.getLeft();
            int meta = (Integer)triple3.getMiddle();
            NBTTagCompound nbt = (NBTTagCompound)triple3.getRight();
            if (ignoreStackSize) {
                toAdd = new ItemStack(item, count, meta);
                toAdd.func_77982_d(nbt);
                list.add(toAdd);
                continue;
            }
            for (count = entry.getIntValue(); count > 0; count -= limit) {
                toAdd = new ItemStack(item, 1, meta);
                toAdd.func_77982_d(nbt);
                limit = item.getItemStackLimit(toAdd);
                toAdd.func_190920_e(Math.min(count, limit));
                list.add(toAdd);
            }
        }
        map.clear();
        return list;
    }

    public static NBTTagList saveAllItems(NBTTagList tagList, List<ItemStack> list) {
        return MiscUtil.saveAllItems(tagList, list, "Index");
    }

    public static NBTTagList saveAllItems(NBTTagList tagList, List<ItemStack> list, String indexKey) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = list.get(i);
            boolean empty = stack.func_190926_b();
            if (empty && i != list.size() - 1) continue;
            if (empty) {
                stack = new ItemStack((Item)null);
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a(indexKey, (byte)i);
            MiscUtil.saveItemWithLargeCount(nbt, stack);
            tagList.func_74742_a((NBTBase)nbt);
        }
        return tagList;
    }

    public static void loadAllItems(NBTTagList tagList, List<ItemStack> list) {
        MiscUtil.loadAllItems(tagList, list, "Index");
    }

    public static void loadAllItems(NBTTagList tagList, List<ItemStack> list, String indexKey) {
        list.clear();
        try {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nbt = tagList.func_150305_b(i);
                int j = nbt.func_74771_c(indexKey) & 0xFF;
                while (j >= list.size()) {
                    list.add(ItemStack.field_190927_a);
                }
                if (j < 0) continue;
                ItemStack stack = MiscUtil.loadItemWithLargeCount(nbt);
                list.set(j, stack.func_190926_b() ? ItemStack.field_190927_a : stack);
            }
        }
        catch (IndexOutOfBoundsException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    public static NBTTagCompound saveItemWithLargeCount(NBTTagCompound nbt, ItemStack stack) {
        stack.func_77955_b(nbt);
        int count = stack.func_190916_E();
        if ((byte)count == count) {
            nbt.func_74774_a("Count", (byte)count);
        } else if ((short)count == count) {
            nbt.func_74777_a("Count", (short)count);
        } else {
            nbt.func_74768_a("Count", (int)((short)count));
        }
        return nbt;
    }

    public static ItemStack loadItemWithLargeCount(NBTTagCompound nbt) {
        ItemStack stack = new ItemStack(nbt);
        stack.func_190920_e(nbt.func_74762_e("Count"));
        return stack;
    }

    public static void writeItemWithLargeCount(ByteBuf buf, ItemStack stack) {
        if (stack.func_190926_b()) {
            buf.writeBoolean(false);
            return;
        }
        buf.writeBoolean(true);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)Item.func_150891_b((Item)stack.func_77973_b()), (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)stack.func_190916_E(), (int)5);
        buf.writeShort(stack.func_77960_j());
        NBTTagCompound nbt = null;
        if (stack.func_77973_b().func_77645_m() || stack.func_77973_b().func_77651_p()) {
            nbt = stack.func_77973_b().getNBTShareTag(stack);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static ItemStack readItemWithLargeCount(ByteBuf buf) {
        if (!buf.readBoolean()) {
            return ItemStack.field_190927_a;
        }
        int id = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        int count = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        short meta = buf.readShort();
        ItemStack stack = new ItemStack(Item.func_150899_d((int)id), count, (int)meta);
        stack.func_77973_b().readNBTShareTag(stack, ByteBufUtils.readTag((ByteBuf)buf));
        return stack;
    }

    public static IPackagePattern getPatternHelper(IRecipeInfo recipeInfo, int index) {
        try {
            Class<?> helperClass = Class.forName("thelm.packagedauto.util.PatternHelper");
            Constructor<?> helperConstructor = helperClass.getConstructor(IRecipeInfo.class, Integer.TYPE);
            return (IPackagePattern)helperConstructor.newInstance(recipeInfo, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<ItemStack> getRemainingItems(IInventory inventory) {
        return MiscUtil.getRemainingItems(IntStream.range(0, inventory.func_70302_i_()).mapToObj(arg_0 -> ((IInventory)inventory).func_70301_a(arg_0)).collect(Collectors.toList()));
    }

    public static List<ItemStack> getRemainingItems(IInventory inventory, int minInclusive, int maxExclusive) {
        return MiscUtil.getRemainingItems(IntStream.range(minInclusive, maxExclusive).mapToObj(arg_0 -> ((IInventory)inventory).func_70301_a(arg_0)).collect(Collectors.toList()));
    }

    public static List<ItemStack> getRemainingItems(ItemStack ... stacks) {
        return MiscUtil.getRemainingItems(Arrays.asList(stacks));
    }

    public static List<ItemStack> getRemainingItems(List<ItemStack> stacks) {
        NonNullList ret = NonNullList.func_191197_a((int)stacks.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, (Object)MiscUtil.getContainerItem(stacks.get(i)));
        }
        return ret;
    }

    public static ItemStack getContainerItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_77973_b().hasContainerItem(stack)) {
            if (!(stack = stack.func_77973_b().getContainerItem(stack)).func_190926_b() && stack.func_77984_f() && stack.func_77960_j() > stack.func_77958_k()) {
                return ItemStack.field_190927_a;
            }
            return stack;
        }
        if (stack.func_190916_E() > 1) {
            stack = stack.func_77946_l();
            stack.func_190920_e(stack.func_190916_E() - 1);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.func_190920_e(stackSize);
        return retStack;
    }

    public static boolean isEmpty(IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static NBTTagCompound writeRecipeToNBT(NBTTagCompound nbt, IRecipeInfo recipe) {
        nbt.func_74778_a("RecipeType", recipe.getRecipeType().getName().toString());
        recipe.writeToNBT(nbt);
        return nbt;
    }

    public static IRecipeInfo readRecipeFromNBT(NBTTagCompound nbt) {
        IRecipeType recipeType = RecipeTypeRegistry.getRecipeType(new ResourceLocation(nbt.func_74779_i("RecipeType")));
        if (recipeType != null) {
            IRecipeInfo recipe = (IRecipeInfo)RECIPE_CACHE.getIfPresent((Object)nbt);
            if (recipe != null) {
                return recipe;
            }
            recipe = recipeType.getNewRecipeInfo();
            recipe.readFromNBT(nbt);
            RECIPE_CACHE.put((Object)nbt, (Object)recipe);
            return recipe;
        }
        return null;
    }

    public static NBTTagList writeRecipeListToNBT(NBTTagList tagList, List<IRecipeInfo> recipes) {
        for (IRecipeInfo recipe : recipes) {
            tagList.func_74742_a((NBTBase)MiscUtil.writeRecipeToNBT(new NBTTagCompound(), recipe));
        }
        return tagList;
    }

    public static List<IRecipeInfo> readRecipeListFromNBT(NBTTagList tagList) {
        ArrayList<IRecipeInfo> recipes = new ArrayList<IRecipeInfo>(tagList.func_74745_c());
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            IRecipeInfo recipe = MiscUtil.readRecipeFromNBT(tagList.func_150305_b(i));
            if (recipe == null) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    public static boolean recipeEquals(IRecipeInfo recipeA, Object recipeInternalA, IRecipeInfo recipeB, Object recipeInternalB) {
        int i;
        if (!Objects.equals(recipeInternalA, recipeInternalB)) {
            return false;
        }
        List<ItemStack> inputsA = recipeA.getInputs();
        List<ItemStack> inputsB = recipeB.getInputs();
        if (inputsA.size() != inputsB.size()) {
            return false;
        }
        List<ItemStack> outputsA = recipeA.getOutputs();
        List<ItemStack> outputsB = recipeB.getOutputs();
        if (outputsA.size() != outputsB.size()) {
            return false;
        }
        for (i = 0; i < inputsA.size(); ++i) {
            if (ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)inputsA.get(i), (ItemStack)inputsB.get(i))) continue;
            return false;
        }
        for (i = 0; i < outputsA.size(); ++i) {
            if (ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)outputsA.get(i), (ItemStack)outputsB.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public static int recipeHashCode(IRecipeInfo recipe, Object recipeInternal) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean removeExactSet(List<ItemStack> offered, List<ItemStack> required, boolean simulate) {
        List<ItemStack> condensedRequired = MiscUtil.condenseStacks(required, true);
        List<ItemStack> condensedOffered = MiscUtil.condenseStacks(offered, true);
        block0: for (ItemStack req : condensedRequired) {
            for (ItemStack offer : condensedOffered) {
                if (req.func_190916_E() > offer.func_190916_E() || !req.func_77969_a(offer) || req.func_77942_o() && !ItemStack.areItemStackShareTagsEqual((ItemStack)req, (ItemStack)offer)) continue;
                continue block0;
            }
            return false;
        }
        if (simulate) {
            return true;
        }
        for (ItemStack req : condensedRequired) {
            int count = req.func_190916_E();
            for (ItemStack offer : offered) {
                if (offer.func_190926_b() || !req.func_77969_a(offer) || req.func_77942_o() && !ItemStack.areItemStackShareTagsEqual((ItemStack)req, (ItemStack)offer)) continue;
                int toRemove = Math.min(count, offer.func_190916_E());
                offer.func_190918_g(toRemove);
                if ((count -= toRemove) != 0) continue;
            }
        }
        return true;
    }

    public static boolean arePatternsDisjoint(List<IPackagePattern> patternList) {
        ObjectRBTreeSet set = new ObjectRBTreeSet(Comparator.comparing(triple -> Triple.of((Object)((Item)triple.getLeft()).getRegistryName(), (Object)triple.getMiddle(), (Object)("" + triple.getRight()))));
        for (IPackagePattern pattern : patternList) {
            List<ItemStack> condensedInputs = MiscUtil.condenseStacks(pattern.getInputs(), true);
            for (ItemStack stack : condensedInputs) {
                Triple toAdd = Triple.of((Object)stack.func_77973_b(), (Object)stack.func_77952_i(), (Object)stack.func_77978_p());
                if (set.contains((Object)toAdd)) {
                    return false;
                }
                set.add((Object)toAdd);
            }
        }
        set.clear();
        return true;
    }

    public static ItemStack insertItem(IItemHandler itemHandler, ItemStack stack, boolean requireEmptySlot, boolean simulate) {
        if (itemHandler == null || stack.func_190926_b()) {
            return stack;
        }
        if (!requireEmptySlot) {
            return ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemHandler.getStackInSlot(slot).func_190926_b() || !(stack = itemHandler.insertItem(slot, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static Runnable conditionalRunnable(BooleanSupplier conditionSupplier, Supplier<Runnable> trueRunnable, Supplier<Runnable> falseRunnable) {
        return () -> ((Runnable)(conditionSupplier.getAsBoolean() ? trueRunnable : falseRunnable).get()).run();
    }

    public static <T> Supplier<T> conditionalSupplier(BooleanSupplier conditionSupplier, Supplier<Supplier<T>> trueSupplier, Supplier<Supplier<T>> falseSupplier) {
        return () -> ((Supplier)(conditionSupplier.getAsBoolean() ? trueSupplier : falseSupplier).get()).get();
    }
}

