/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.container.ContainerEncoder;
import thelm.packagedauto.integration.jei.category.PackageRecipeWrapper;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.PacketSetRecipe;

public class PackageRecipeTransferHandler
implements IRecipeTransferHandler<ContainerEncoder> {
    private final IRecipeTransferHandlerHelper transferHelper;

    public PackageRecipeTransferHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    public Class<ContainerEncoder> getContainerClass() {
        return ContainerEncoder.class;
    }

    public IRecipeTransferError transferRecipe(ContainerEncoder container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        Int2ObjectMap<ItemStack> map;
        IRecipeInfo recipeInfo;
        try {
            Field recipeField = recipeLayout.getClass().getDeclaredField("recipeWrapper");
            recipeField.setAccessible(true);
            Object recipe = recipeField.get(recipeLayout);
            if (!(recipe instanceof PackageRecipeWrapper)) {
                return this.transferHelper.createInternalError();
            }
            recipeInfo = ((PackageRecipeWrapper)recipe).recipe;
        }
        catch (Exception e) {
            return this.transferHelper.createInternalError();
        }
        IRecipeType recipeType = container.patternInventory.recipeType;
        if (recipeInfo.getRecipeType() == recipeType) {
            map = recipeInfo.getEncoderStacks();
        } else if (recipeType.getJEICategories().contains("packagedauto:package_recipe")) {
            map = recipeType.getRecipeTransferMap(recipeLayout, "packagedauto:package_recipe");
        } else {
            return this.transferHelper.createInternalError();
        }
        if (map == null || map.isEmpty()) {
            return this.transferHelper.createInternalError();
        }
        if (!doTransfer) {
            return null;
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetRecipe(map));
        return null;
    }
}

