/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.block.FluidPackageFillerBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.FluidPackageFillerItemHandler;
import thelm.packagedauto.menu.FluidPackageFillerMenu;
import thelm.packagedauto.util.MiscHelper;

public class FluidPackageFillerBlockEntity
extends BaseBlockEntity
implements ISettingsCloneable {
    public static final BlockEntityType<FluidPackageFillerBlockEntity> TYPE_INSTANCE = (BlockEntityType)BlockEntityType.Builder.m_155273_(FluidPackageFillerBlockEntity::new, (Block[])new Block[]{FluidPackageFillerBlock.INSTANCE}).m_58966_(null).setRegistryName("packagedauto:fluid_package_filler");
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static int refreshInterval = 4;
    public boolean firstTick = true;
    public boolean isWorking = false;
    public FluidStack currentFluid = FluidStack.EMPTY;
    public int requiredAmount = 100;
    public int amount = 0;
    public int remainingProgress = 0;
    public boolean powered = false;
    public boolean activated = false;

    public FluidPackageFillerBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new FluidPackageFillerItemHandler(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
    }

    @Override
    protected Component getDefaultName() {
        return new TranslatableComponent("block.packagedauto.fluid_package_filler");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.fluid_package_filler";
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.updatePowered();
        }
        if (!this.f_58857_.f_46443_) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0 && this.isTemplateValid()) {
                    this.finishProcess();
                    if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
                        this.ejectItem();
                    }
                    if (!this.canStart()) {
                        this.endProcess();
                    } else {
                        this.startProcess();
                    }
                }
            } else if (this.activated && this.canStart()) {
                this.startProcess();
                this.tickProcess();
                this.activated = false;
                this.isWorking = true;
            }
            this.chargeEnergy();
            if (this.f_58857_.m_46467_() % (long)refreshInterval == 0L && !this.itemHandler.getStackInSlot(1).m_41619_()) {
                this.ejectItem();
            }
        }
    }

    public boolean isTemplateValid() {
        if (this.currentFluid.isEmpty()) {
            this.getFluid();
        }
        return !this.currentFluid.isEmpty();
    }

    public boolean canStart() {
        this.getFluid();
        if (this.currentFluid.isEmpty()) {
            return false;
        }
        if (!this.isTemplateValid()) {
            return false;
        }
        ItemStack slotStack = this.itemHandler.getStackInSlot(1);
        ItemStack outputStack = MiscHelper.INSTANCE.tryMakeVolumePackage(this.currentFluid);
        return slotStack.m_41619_() || ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.m_41613_() + 1 <= outputStack.m_41741_();
    }

    protected boolean canFinish() {
        return this.remainingProgress <= 0 && this.isTemplateValid();
    }

    protected void getFluid() {
        this.currentFluid = FluidStack.EMPTY;
        ItemStack template = this.itemHandler.getStackInSlot(0);
        if (template.m_41619_()) {
            return;
        }
        FluidUtil.getFluidContained((ItemStack)template).filter(s -> !s.isEmpty()).ifPresent(s -> {
            this.currentFluid = s.copy();
            this.currentFluid.setAmount(this.requiredAmount);
        });
    }

    protected void tickProcess() {
        if (this.amount < this.requiredAmount) {
            for (Direction direction : Direction.values()) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
                if (blockEntity == null || !blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_()).isPresent()) continue;
                IFluidHandler fluidHandler = (IFluidHandler)blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_()).resolve().get();
                FluidStack toDrain = this.currentFluid.copy();
                toDrain.setAmount(this.requiredAmount - this.amount);
                this.amount += fluidHandler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE).getAmount();
            }
        }
        if (this.amount >= this.requiredAmount) {
            int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
            this.remainingProgress -= energy;
        }
    }

    protected void finishProcess() {
        if (this.currentFluid.isEmpty()) {
            this.getFluid();
        }
        if (this.currentFluid.isEmpty()) {
            this.endProcess();
            return;
        }
        if (this.itemHandler.getStackInSlot(1).m_41619_()) {
            this.itemHandler.setStackInSlot(1, MiscHelper.INSTANCE.tryMakeVolumePackage(this.currentFluid));
        } else if (this.itemHandler.getStackInSlot(1).m_41720_() instanceof IVolumePackageItem) {
            this.itemHandler.getStackInSlot(1).m_41769_(1);
        }
        this.endProcess();
    }

    public void startProcess() {
        this.remainingProgress = energyReq;
        this.amount = 0;
        this.sync(false);
        this.m_6596_();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.amount = 0;
        this.isWorking = false;
        this.m_6596_();
    }

    protected void ejectItem() {
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
            if (blockEntity == null || blockEntity instanceof UnpackagerBlockEntity || !blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).isPresent() || blockEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.m_122424_()).isPresent()) continue;
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).resolve().get();
            ItemStack stack = this.itemHandler.getStackInSlot(1);
            if (stack.m_41619_()) continue;
            ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            this.itemHandler.setStackInSlot(1, stackRem);
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(2);
        if (energyStack.getCapability(CapabilityEnergy.ENERGY).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.m_41613_() <= 0) {
                this.itemHandler.setStackInSlot(2, ItemStack.f_41583_);
            }
        }
    }

    public void updatePowered() {
        if (this.f_58857_.m_46755_(this.f_58858_) > 0 != this.powered) {
            boolean bl = this.powered = !this.powered;
            if (this.powered && !this.isWorking) {
                this.activated = true;
            }
            this.m_6596_();
        }
    }

    @Override
    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
            return 15;
        }
        return 0;
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
        this.requiredAmount = nbt.m_128451_("AmountReq");
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
        nbt.m_128405_("AmountReq", this.requiredAmount);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isWorking = nbt.m_128471_("Working");
        this.amount = nbt.m_128451_("Amount");
        this.remainingProgress = nbt.m_128451_("Progress");
        this.powered = nbt.m_128471_("Powered");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Working", this.isWorking);
        nbt.m_128405_("Amount", this.amount);
        nbt.m_128405_("Progress", this.remainingProgress);
        nbt.m_128379_("Powered", this.powered);
    }

    @Override
    public void loadSync(CompoundTag nbt) {
        super.loadSync(nbt);
        this.requiredAmount = nbt.m_128451_("AmountReq");
        this.currentFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("Fluid"));
    }

    @Override
    public CompoundTag saveSync(CompoundTag nbt) {
        super.saveSync(nbt);
        nbt.m_128405_("AmountReq", this.requiredAmount);
        nbt.m_128365_("Fluid", (Tag)this.currentFluid.writeToNBT(new CompoundTag()));
        return nbt;
    }

    public void m_6596_() {
        if (this.isWorking && !this.isTemplateValid()) {
            this.endProcess();
        }
        super.m_6596_();
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0 || energyReq <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new FluidPackageFillerMenu(windowId, inventory, this);
    }
}

