/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.api.IVolumeStackWrapper;

public class SimpleInput
implements IPatternDetails.IInput {
    private final IPackageRecipeInfo recipe;
    private final GenericStack[] template;
    private final long multiplier;

    public SimpleInput(IPackageRecipeInfo recipe, GenericStack stack) {
        this.recipe = recipe;
        this.template = new GenericStack[]{this.getGenericInput(stack)};
        this.multiplier = stack.amount();
    }

    public GenericStack[] getPossibleInputs() {
        return this.template;
    }

    public long getMultiplier() {
        return this.multiplier;
    }

    public boolean isValid(AEKey input, Level level) {
        return input.matches(this.template[0]);
    }

    public AEKey getRemainingKey(AEKey template) {
        if (this.recipe != null && this.recipe.getRecipeType().hasContainerItem() && template instanceof AEItemKey) {
            AEItemKey itemTemplate = (AEItemKey)template;
            return AEItemKey.of((ItemStack)this.recipe.getContainerItem(itemTemplate.toStack()));
        }
        return null;
    }

    private GenericStack getGenericInput(GenericStack stack) {
        AEKey key;
        IVolumePackageItem vPackage;
        IVolumeStackWrapper vStack;
        AEItemKey itemKey;
        AEKey aEKey = stack.what();
        if (aEKey instanceof AEItemKey && (aEKey = (itemKey = (AEItemKey)aEKey).getItem()) instanceof IVolumePackageItem && !(vStack = (vPackage = (IVolumePackageItem)aEKey).getVolumeStack(itemKey.toStack())).isEmpty() && vStack.getVolumeType().supportsAE() && (key = AEKey.fromTagGeneric((CompoundTag)vStack.saveAEKey(new CompoundTag()))) != null) {
            return new GenericStack(key, (long)vStack.getAmount());
        }
        return new GenericStack(stack.what(), 1L);
    }
}

