/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.integration.jei.RecipeSlotsViewWrapper;
import thelm.packagedauto.integration.jei.category.PackageRecipeCategory;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.SetRecipePacket;

public class PackageRecipeTransferHandler
implements IRecipeTransferHandler<EncoderMenu, IPackageRecipeInfo> {
    private final IRecipeTransferHandlerHelper transferHelper;

    public PackageRecipeTransferHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    public Class<EncoderMenu> getContainerClass() {
        return EncoderMenu.class;
    }

    public Class<IPackageRecipeInfo> getRecipeClass() {
        return IPackageRecipeInfo.class;
    }

    public IRecipeTransferError transferRecipe(EncoderMenu menu, IPackageRecipeInfo recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        Int2ObjectMap<ItemStack> map;
        IPackageRecipeType recipeType = menu.patternItemHandler.recipeType;
        if (recipe.getRecipeType() == recipeType) {
            map = recipe.getEncoderStacks();
        } else if (recipeType.getJEICategories().contains(PackageRecipeCategory.TYPE.getUid())) {
            map = recipeType.getRecipeTransferMap(new RecipeSlotsViewWrapper(recipe, recipeSlots));
        } else {
            return this.transferHelper.createInternalError();
        }
        if (map == null || map.isEmpty()) {
            return this.transferHelper.createInternalError();
        }
        if (!doTransfer) {
            return null;
        }
        PacketHandler.INSTANCE.sendToServer((Object)new SetRecipePacket(map));
        return null;
    }
}

