/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.network.PacketHandler;

public record SyncEnergyPacket(BlockPos pos, int energy) {
    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.energy);
    }

    public static SyncEnergyPacket decode(FriendlyByteBuf buf) {
        return new SyncEnergyPacket(buf.m_130135_(), buf.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity be;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level.m_46749_(this.pos) && (be = level.m_7702_(this.pos)) instanceof BaseBlockEntity) {
                BaseBlockEntity bbe = (BaseBlockEntity)be;
                bbe.getEnergyStorage().setEnergyStored(this.energy);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void syncEnergy(BlockPos pos, int energy, ResourceKey<Level> dimension, double range) {
        PacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, range, dimension)), (Object)new SyncEnergyPacket(pos, energy));
    }
}

