package thelm.packagedauto.block;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.client.IModelRegister;
import thelm.packagedauto.tile.TileBase;

public abstract class BlockBase extends Block implements ITileEntityProvider, IModelRegister {

	public BlockBase(Material material) {
		super(material);
	}

	public BlockBase(Material material, MapColor mapColor) {
		super(material, mapColor);
	}

	@Override
	public abstract TileBase func_149915_a(World worldIn, int meta);

	@Override
	public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
		if(te instanceof TileBase && ((TileBase)te).func_145818_k_()) {
			player.func_71029_a(StatList.func_188055_a(this));
			player.func_71020_j(0.005F);
			if(worldIn.field_72995_K) {
				return;
			}
			int i = EnchantmentHelper.func_77506_a(Enchantments.field_185308_t, stack);
			Item item = func_180660_a(state, worldIn.field_73012_v, i);
			if(item == Items.field_190931_a) {
				return;
			}
			ItemStack itemstack = new ItemStack(item, this.func_149745_a(worldIn.field_73012_v));
			itemstack.func_151001_c(((IWorldNameable)te).func_70005_c_());
			func_180635_a(worldIn, pos, itemstack);
		}
		else {
			super.func_180657_a(worldIn, player, pos, state, te, stack);
		}
	}

	@Override
	public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
		super.func_189539_a(state, worldIn, pos, id, param);
		TileEntity tileentity = worldIn.func_175625_s(pos);
		return tileentity == null ? false : tileentity.func_145842_c(id, param);
	}

	@Override
	public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		if(playerIn.func_70093_af()) {
			return false;
		}
		if(!worldIn.field_72995_K) {
			playerIn.openGui(PackagedAuto.MOD_ID, facing.func_176745_a(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
			return true;
		}
		return true;
	}

	@Override
	public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
		super.func_180633_a(worldIn, pos, state, placer, stack);
		if(!worldIn.field_72995_K) {
			TileEntity tileentity = worldIn.func_175625_s(pos);
			if(tileentity instanceof TileBase) {
				if(stack.func_82837_s()) {
					((TileBase)tileentity).setCustomName(stack.func_82833_r());
				}
				if(placer instanceof EntityPlayer) {
					((TileBase)tileentity).setOwner((EntityPlayer)placer);
				}
			}
		}
	}

	@Override
	public void func_180663_b(World worldIn, BlockPos pos, IBlockState state)  {
		TileEntity tileentity = worldIn.func_175625_s(pos);
		if(tileentity instanceof TileBase) {
			InventoryHelper.func_180175_a(worldIn, pos, ((TileBase)tileentity).getInventory());
			worldIn.func_175666_e(pos, this);
		}
		super.func_180663_b(worldIn, pos, state);
	}

	@Override
	public boolean func_149740_M(IBlockState state) {
		return true;
	}

	@Override
	public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
		TileEntity tileentity = worldIn.func_175625_s(pos);
		if(tileentity instanceof TileBase) {
			return ((TileBase)tileentity).getComparatorSignal();
		}
		return 0;
	}
}
